/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.gadget.ide.ui;

import java.rmi.RemoteException;
import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.gadget.ide.stub.GadgetIDEAdminException;
import org.wso2.carbon.gadget.ide.stub.GadgetIDEAdminStub;

public class GadgetIDEAdminClient {
    private static final Log log = LogFactory.getLog(GadgetIDEAdminClient.class);
    private static final String BUNDLE_NAME = "org.wso2.carbon.gadget.ide.ui.i18n.Resources";
    private GadgetIDEAdminStub stub;
    private ResourceBundle bundle;
    private String operationSig;

    public GadgetIDEAdminClient(String cookie, String backendServerURL, ConfigurationContext configCtx, Locale locale) throws AxisFault {
        String serviceURL = backendServerURL + "GadgetIDEAdmin";
        this.bundle = ResourceBundle.getBundle(BUNDLE_NAME, locale);
        this.stub = new GadgetIDEAdminStub(configCtx, serviceURL);
        ServiceClient client = this.stub._getServiceClient();
        Options option = client.getOptions();
        option.setManageSession(true);
        option.setProperty("Cookie", (Object)cookie);
    }

    public String[] getOperations(String uri, String binding) throws RemoteException {
        String[] operations = new String[]{};
        try {
            operations = this.stub.getOperations(uri, binding);
            return operations;
        }
        catch (GadgetIDEAdminException e) {
            this.logAndThrow(this.bundle.getString("cannot.get.operations"), (Exception)((Object)e));
            return null;
        }
    }

    public boolean saveTempSettings(String settings) throws RemoteException {
        try {
            return this.stub.saveTempSettings(settings);
        }
        catch (GadgetIDEAdminException e) {
            this.logAndThrow(this.bundle.getString("cannot.save.settings"), (Exception)((Object)e));
            return false;
        }
    }

    public boolean generateCode() throws RemoteException {
        try {
            return this.stub.generateCode();
        }
        catch (GadgetIDEAdminException e) {
            this.logAndThrow(this.bundle.getString("cannot.generate.code"), (Exception)((Object)e));
            return false;
        }
    }

    private void logAndThrow(String msg, Exception e) throws RemoteException {
        log.error((Object)msg, (Throwable)e);
        throw new RemoteException(msg, e);
    }

    public String[] getEndpoints(String uri) throws RemoteException {
        try {
            String[] endpoints = this.stub.getEndpoints(uri);
            return endpoints;
        }
        catch (GadgetIDEAdminException e) {
            this.logAndThrow(this.bundle.getString("cannot.get.endpoints"), (Exception)((Object)e));
            return null;
        }
    }

    public String getStub(String uri, String endpoint, String operation) throws RemoteException {
        try {
            return this.stub.getStub(uri);
        }
        catch (GadgetIDEAdminException e) {
            this.logAndThrow(this.bundle.getString("cannot.generate.stub"), (Exception)((Object)e));
            return null;
        }
    }

    public String getOperationSig(String uri, String endpoint, String operation) throws RemoteException {
        try {
            return this.stub.getOperationSig(uri, endpoint, operation);
        }
        catch (GadgetIDEAdminException e) {
            this.logAndThrow(this.bundle.getString("cannot.get.sig"), (Exception)((Object)e));
            return null;
        }
    }

    public String deploy(String gadgetXmlName) throws RemoteException {
        try {
            return this.stub.deploy(gadgetXmlName);
        }
        catch (GadgetIDEAdminException e) {
            this.logAndThrow(this.bundle.getString("cannot.deploy"), (Exception)((Object)e));
            return null;
        }
    }
}

