/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.wsdl2form;

import java.util.Map;
import java.util.Set;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.OperationContext;
import org.apache.axis2.description.AxisBinding;
import org.apache.axis2.description.AxisEndpoint;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.engine.AxisEngine;
import org.apache.axis2.receivers.AbstractMessageReceiver;
import org.apache.axis2.util.MessageContextBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.wsdl2form.internal.WSDL2FormServiceComponent;

public class ProxyMessageReceiver
extends AbstractMessageReceiver {
    private static Log log = LogFactory.getLog(ProxyMessageReceiver.class);

    protected void invokeBusinessLogic(MessageContext inMessage) throws AxisFault {
        SOAPEnvelope env = inMessage.getEnvelope();
        AxisService axisServce = inMessage.getAxisService();
        axisServce.addParameter("_LAST_TOUCH_TIME_", (Object)System.currentTimeMillis());
        Map endpoints = axisServce.getEndpoints();
        Set set = endpoints.keySet();
        AxisEndpoint endpoint = null;
        for (String key : set) {
            endpoint = (AxisEndpoint)endpoints.get(key);
            String endpointURL = endpoint.getEndpointURL();
            if (endpointURL.indexOf("http://") <= -1) continue;
            AxisBinding binding = endpoint.getBinding();
            String wsoapVersion = (String)binding.getProperty("wsoap:version");
            String inSOAPNamespace = env.getNamespace().getNamespaceURI();
            if (!inSOAPNamespace.equals(wsoapVersion)) continue;
        }
        if (endpoint == null) {
            String msg = ProxyMessageReceiver.class.getName() + " cannot find real endpoint";
            log.error((Object)msg);
            throw new AxisFault(msg);
        }
        ConfigurationContext configCtx = WSDL2FormServiceComponent.getConfigurationContextService().getClientConfigContext();
        ServiceClient client = new ServiceClient(configCtx, null);
        OMElement element = env.getBody().getFirstElement();
        if (element != null) {
            element.detach();
        }
        Options options = new Options();
        options.setTo(new EndpointReference(endpoint.getEndpointURL()));
        options.setAction(inMessage.getWSAAction());
        options.setSoapVersionURI(env.getNamespace().getNamespaceURI());
        options.setProperty("__CHUNKED__", (Object)Boolean.FALSE);
        options.setTimeOutInMilliSeconds(600000L);
        client.setOptions(options);
        client.disengageModule("addressing");
        int i = inMessage.getAxisOperation().getAxisSpecificMEPConstant();
        MessageContext outMsgContext = null;
        if (i == 12) {
            outMsgContext = MessageContextBuilder.createOutMessageContext((MessageContext)inMessage);
            outMsgContext.getOperationContext().addMessageContext(outMsgContext);
        }
        try {
            if (i == 12) {
                client.sendReceive(element);
            } else {
                client.sendRobust(element);
            }
        }
        catch (AxisFault axisFault) {
            env = this.getResponseEnvelope(client);
            if (env != null && env.getBody().hasFault()) {
                throw new AxisFault(env.getBody().getFault());
            }
            String msg = ProxyMessageReceiver.class.getName() + " proxy encountered an error";
            log.error((Object)msg);
            throw new AxisFault(msg);
        }
        env = this.getResponseEnvelope(client);
        if (env != null && outMsgContext != null) {
            outMsgContext.setEnvelope(env);
            AxisEngine.send((MessageContext)outMsgContext);
        }
    }

    private SOAPEnvelope getResponseEnvelope(ServiceClient client) throws AxisFault {
        OperationContext operationContext = client.getLastOperationContext();
        MessageContext messageContext = operationContext.getMessageContext("In");
        if (messageContext != null) {
            return messageContext.getEnvelope();
        }
        return null;
    }
}

