/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.gadget.ide.sigdom;

import java.util.LinkedHashMap;
import java.util.Map;
import javax.xml.transform.dom.DOMSource;
import org.wso2.carbon.gadget.ide.sigdom.DomProvider;

public class CachedDomProvider
implements DomProvider {
    private Map<String, DOMSource> cache;
    private DomProvider provider;
    private final int cacheMaxSize;

    public CachedDomProvider(DomProvider provider, int cacheMaxSize) {
        this.cacheMaxSize = cacheMaxSize;
        this.provider = provider;
    }

    private void crateCache() {
        this.cache = new LinkedHashMap<String, DOMSource>(){

            @Override
            protected boolean removeEldestEntry(Map.Entry<String, DOMSource> eldest) {
                return this.size() > CachedDomProvider.this.cacheMaxSize;
            }
        };
    }

    private DOMSource recover(String keyURI) {
        if (this.cache == null) {
            return null;
        }
        return this.cache.get(keyURI);
    }

    private synchronized void admit(String keyURI, DOMSource data) {
        if (this.cache == null) {
            this.crateCache();
        }
        this.cache.put(keyURI, data);
    }

    public int getMaxSize() {
        return this.cacheMaxSize;
    }

    @Override
    public DOMSource getSigDom(String uri) {
        DOMSource domSource = this.recover(uri);
        if (domSource == null && (domSource = this.provider.getSigDom(uri)) != null) {
            this.admit(uri, domSource);
        }
        return domSource;
    }
}

