/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.wsdl2form;

import java.io.OutputStream;
import javax.xml.transform.stream.StreamResult;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.CarbonException;
import org.wso2.carbon.core.transports.CarbonHttpRequest;
import org.wso2.carbon.core.transports.CarbonHttpResponse;
import org.wso2.carbon.core.transports.HttpGetRequestProcessor;
import org.wso2.carbon.wsdl2form.WSDL2FormGenerator;

public class StubRequestProcessor
implements HttpGetRequestProcessor {
    private static Log log = LogFactory.getLog(StubRequestProcessor.class);

    public void process(CarbonHttpRequest request, CarbonHttpResponse response, ConfigurationContext configurationContext) throws Exception {
        OutputStream outputStream = response.getOutputStream();
        String requestURL = request.getRequestURL() + "?" + request.getQueryString();
        String serviceParameter = request.getParameter("service");
        String endpointParameter = request.getParameter("endpoint");
        String languageParameter = request.getParameter("lang");
        String localhostParameter = request.getParameter("localhost");
        String contentTypeParameter = request.getParameter("content-type");
        try {
            StreamResult result = new StreamResult(outputStream);
            String contentType = WSDL2FormGenerator.getInstance().getJSStub(result, configurationContext, requestURL, serviceParameter, endpointParameter, languageParameter, localhostParameter, contentTypeParameter);
            response.addHeader("Content-Type", contentType);
        }
        catch (CarbonException e) {
            log.error((Object)"Cannot generate stub", (Throwable)e);
            response.addHeader("Content-Type", "text/html; charset=utf-8");
            if (e.getMessage().equals("SERVICE_INACTIVE")) {
                response.setStatus(404);
                outputStream.write("<h4>Requested Service is inactive. Cannot generate stubs.</h4>".getBytes());
                outputStream.flush();
                return;
            }
            if (e.getMessage().equals("SERVICE_NOT_FOUND")) {
                response.setStatus(503);
                outputStream.write("<h4>Service cannot be found. Cannot display <em>Stub</em>.</h4>".getBytes());
                outputStream.flush();
                return;
            }
            if (e.getMessage().equals("UNSUPPORTED_LANG")) {
                response.setError(404);
                outputStream.write(("<h4>Unsupported lang parameter " + languageParameter + "</h4>").getBytes());
                outputStream.flush();
                return;
            }
            response.setError(404);
            response.addHeader("Content-Type", "text/html; charset=utf-8");
            outputStream.write(("<h4>" + e.getMessage() + "</h4>").getBytes());
            outputStream.flush();
            return;
        }
    }
}

