/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.gadget.ide.util;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;
import org.wso2.carbon.datasource.DataSourceInformationRepositoryService;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.registry.core.session.UserRegistry;

public class Utils {
    private static DataSourceInformationRepositoryService dataSourceService;
    private static RegistryService registryService;
    private static UserRegistry configReg;
    private static UserRegistry userRegistry;

    public static DataSourceInformationRepositoryService getCarbonDataSourceService() {
        return dataSourceService;
    }

    public static void setCarbonDataSourceService(DataSourceInformationRepositoryService service) {
        dataSourceService = service;
    }

    public static void setRegistryService(RegistryService service) {
        registryService = service;
        try {
            userRegistry = service.getConfigSystemRegistry();
        }
        catch (RegistryException registryException) {
            // empty catch block
        }
    }

    public static OMDocument ResultSet2DOM(ResultSet rs) throws SQLException {
        OMDocument myDocument = null;
        OMFactory omFactory = OMAbstractFactory.getOMFactory();
        myDocument = omFactory.createOMDocument();
        OMElement root = omFactory.createOMElement(QName.valueOf("result"));
        myDocument.addChild((OMNode)root);
        ResultSetMetaData rsmd = rs.getMetaData();
        while (!rs.isLast()) {
            rs.next();
            OMElement row = omFactory.createOMElement(QName.valueOf("row"));
            root.addChild((OMNode)row);
            for (int i = 1; i <= rsmd.getColumnCount(); ++i) {
                OMElement element = omFactory.createOMElement(new QName(rsmd.getColumnLabel(i)));
                String value = rs.getString(i);
                if (value == null) {
                    OMAttribute omAttribute = omFactory.createOMAttribute("xsi:nil", omFactory.createOMNamespace("http://www.w3.org/2001/XMLSchema-instance", "xsi"), "true");
                } else {
                    element.addChild((OMNode)omFactory.createOMText(rs.getString(i)));
                }
                row.addChild((OMNode)element);
            }
        }
        return myDocument;
    }

    public static UserRegistry getUserRegistry() {
        return userRegistry;
    }
}

