/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.gadget.editor.ui.clients;

import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.gadget.editor.stub.GadgetEditorServiceStub;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.ui.CarbonUIUtil;

public class GadgetEditorServiceClient {
    private static final Log log = LogFactory.getLog(GadgetEditorServiceClient.class);
    private GadgetEditorServiceStub stub;
    private String epr;

    public GadgetEditorServiceClient(String cookie, String backendServerURL, ConfigurationContext configContext) throws RegistryException {
        this.epr = backendServerURL + "GadgetEditorService";
        try {
            this.stub = new GadgetEditorServiceStub(configContext, this.epr);
            ServiceClient client = this.stub._getServiceClient();
            Options option = client.getOptions();
            option.setManageSession(true);
            option.setProperty("Cookie", (Object)cookie);
        }
        catch (AxisFault axisFault) {
            String msg = "Failed to initiate AddServices service client. " + axisFault.getMessage();
            log.error((Object)msg, (Throwable)axisFault);
            throw new RegistryException(msg, (Throwable)axisFault);
        }
    }

    public GadgetEditorServiceClient(ServletConfig config, HttpSession session) throws RegistryException {
        String cookie = (String)session.getAttribute("wso2carbon.admin.service.cookie");
        String backendServerURL = CarbonUIUtil.getServerURL((ServletContext)config.getServletContext(), (HttpSession)session);
        ConfigurationContext configContext = (ConfigurationContext)config.getServletContext().getAttribute("ConfigurationContext");
        this.epr = backendServerURL + "GadgetEditorService";
        try {
            this.stub = new GadgetEditorServiceStub(configContext, this.epr);
            ServiceClient client = this.stub._getServiceClient();
            Options option = client.getOptions();
            option.setManageSession(true);
            option.setProperty("Cookie", (Object)cookie);
        }
        catch (AxisFault axisFault) {
            String msg = "Failed to initiate Add Services service client. " + axisFault.getMessage();
            log.error((Object)msg, (Throwable)axisFault);
            throw new RegistryException(msg, (Throwable)axisFault);
        }
    }

    public String openGadget(String path) throws Exception {
        return this.stub.openGadget(path);
    }

    public boolean saveGadget(String path, String content) throws Exception {
        return this.stub.saveGadget(path, content);
    }

    public boolean isResourceExist(String path) throws Exception {
        return this.stub.isResourceExist(path);
    }

    public String[] getImmediateChildResources(String path) throws Exception {
        return this.stub.getImmediateChildResources(path);
    }
}

