/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.gadget.editor.services;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.core.AbstractAdmin;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.ResourcePath;
import org.wso2.carbon.registry.core.config.RegistryContext;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.utils.RegistryUtils;

public class GadgetEditorService
extends AbstractAdmin {
    private static final Log log = LogFactory.getLog(GadgetEditorService.class);

    public boolean saveGadget(String location, String content) throws RegistryException {
        Registry registry = this.getConfigSystemRegistry();
        if (RegistryUtils.isRegistryReadOnly((RegistryContext)registry.getRegistryContext())) {
            return false;
        }
        try {
            Resource gadget;
            try {
                gadget = registry.get(location);
            }
            catch (RegistryException e) {
                gadget = registry.newResource();
            }
            gadget.setContent((Object)content.getBytes());
            registry.put(location, gadget);
        }
        catch (Exception e) {
            if (e instanceof RegistryException) {
                throw (RegistryException)((Object)e);
            }
            throw new RegistryException("Unable to save editor", (Throwable)e);
        }
        return true;
    }

    public String openGadget(String location) throws RegistryException {
        Registry registry = this.getConfigSystemRegistry();
        if (!registry.resourceExists(new ResourcePath(location).getPath())) {
            return null;
        }
        Resource resource = registry.get(location);
        return new String((byte[])resource.getContent());
    }

    public String[] getImmediateChildResources(String path) {
        return null;
    }

    public boolean isResourceExist(String path) {
        return false;
    }
}

