/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.feature.mgt.ui.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Stack;
import org.wso2.carbon.feature.mgt.stub.prov.data.Feature;
import org.wso2.carbon.feature.mgt.ui.FeatureWrapper;

public class Utils {
    public static int getMaxHeight(FeatureWrapper[] featureWrappers, int maxheight) {
        for (FeatureWrapper featureWrapper : featureWrappers) {
            if (maxheight < featureWrapper.getHeight()) {
                maxheight = featureWrapper.getHeight();
            }
            if (featureWrapper.getRequiredFeatures() == null || featureWrapper.getRequiredFeatures().length <= 0) continue;
            maxheight = Utils.getMaxHeight(featureWrapper.getRequiredFeatures(), maxheight);
        }
        return maxheight;
    }

    public static FeatureWrapper[] processFeatureTree(Feature[] features, int height) {
        FeatureWrapper[] featureWrappers = new FeatureWrapper[features.length];
        for (int i = 0; i < features.length; ++i) {
            featureWrappers[i] = new FeatureWrapper();
            featureWrappers[i].setWrappedFeature(features[i]);
            featureWrappers[i].setHeight(height);
            featureWrappers[i].setHiddenRow(true);
            if (features[i].getRequiredFeatures() != null && features[i].getRequiredFeatures().length > 0) {
                featureWrappers[i].setHasChildren(true);
                FeatureWrapper[] requiredFeatureWrappers = Utils.processFeatureTree(features[i].getRequiredFeatures(), height + 1);
                featureWrappers[i].setRequiredFeatures(requiredFeatureWrappers);
                continue;
            }
            featureWrappers[i].setHasChildren(false);
        }
        return featureWrappers;
    }

    public static FeatureWrapper[] filterFeatures(FeatureWrapper[] originalFeatures, String filterStr) {
        try {
            List<FeatureWrapper> originalFeatureList = Arrays.asList(originalFeatures);
            ArrayList<FeatureWrapper> matchedFeatureList = new ArrayList<FeatureWrapper>();
            for (FeatureWrapper featureWrapper : originalFeatureList) {
                Feature feature = featureWrapper.getWrappedFeature();
                String featureName = feature.getFeatureName();
                if (featureName == null || !featureName.toLowerCase().contains(filterStr.toLowerCase())) continue;
                matchedFeatureList.add(featureWrapper);
            }
            FeatureWrapper[] matchedFeatures = new FeatureWrapper[matchedFeatureList.size()];
            return matchedFeatureList.toArray(matchedFeatures);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new FeatureWrapper[0];
        }
    }

    public static FeatureWrapper[] truncatePrefixAndSuffixOfFeature(FeatureWrapper[] featureList) {
        String prefix1 = "wso2 carbon";
        String prefix2 = "wso2carbon";
        String prefix3 = "wso2";
        String suffix = "feature";
        for (FeatureWrapper featureWrapper : featureList) {
            Feature currentFeature = featureWrapper.getWrappedFeature();
            String featureName = currentFeature.getFeatureName();
            String tempStr = currentFeature.getFeatureName().toLowerCase();
            if (tempStr.startsWith(prefix1)) {
                tempStr = tempStr.substring(prefix1.length()).trim();
                featureName = featureName.substring(prefix1.length()).trim();
            } else if (tempStr.startsWith(prefix2)) {
                tempStr = tempStr.substring(prefix2.length()).trim();
                featureName = featureName.substring(prefix2.length()).trim();
            } else if (tempStr.startsWith(prefix3)) {
                tempStr = tempStr.substring(prefix3.length()).trim();
                featureName = featureName.substring(prefix3.length()).trim();
            }
            if (tempStr.startsWith("-")) {
                tempStr = tempStr.substring(1).trim();
                featureName = featureName.substring(1).trim();
            }
            if (tempStr.endsWith(suffix)) {
                int tempIndex = tempStr.lastIndexOf(suffix);
                tempStr = tempStr.substring(0, tempIndex);
                featureName = featureName.substring(0, tempIndex);
            }
            currentFeature.setFeatureName(featureName.trim());
        }
        return featureList;
    }

    public static void sortAscendingByFeatureName(FeatureWrapper[] featureList) {
        Arrays.sort(featureList, new Comparator(){

            public int compare(Object ob1, Object ob2) {
                String featureName1 = ((FeatureWrapper)ob1).getWrappedFeature().getFeatureName();
                String featureName2 = ((FeatureWrapper)ob2).getWrappedFeature().getFeatureName();
                return featureName1.compareToIgnoreCase(featureName2);
            }
        });
    }

    public static void sortDescendingByFeatureName(FeatureWrapper[] featureList) {
        Arrays.sort(featureList, new Comparator(){

            public int compare(Object ob1, Object ob2) {
                String featureName1 = ((FeatureWrapper)ob1).getWrappedFeature().getFeatureName();
                String featureName2 = ((FeatureWrapper)ob2).getWrappedFeature().getFeatureName();
                return featureName1.compareToIgnoreCase(featureName2);
            }
        });
    }

    public static String getDescriptionOfFeature(FeatureWrapper[] featureWrappers, String featureId) {
        String featureDescription = null;
        for (FeatureWrapper fw : featureWrappers) {
            if (!fw.getWrappedFeature().getFeatureID().equals(featureId)) continue;
            featureDescription = fw.getWrappedFeature().getFeatureDescription();
            break;
        }
        return featureDescription != null && !featureDescription.equals("") ? featureDescription : "no description available";
    }

    public static FeatureWrapper[] getUniqueFeatureList(FeatureWrapper[] featureWrappers) {
        HashSet<FeatureWrapper> featureWrapperSet = new HashSet<FeatureWrapper>();
        for (FeatureWrapper fw : featureWrappers) {
            Stack<FeatureWrapper> featureWrapperStack = new Stack<FeatureWrapper>();
            featureWrapperStack.add(fw);
            while (!featureWrapperStack.isEmpty()) {
                FeatureWrapper popedFeatureWrapper = (FeatureWrapper)featureWrapperStack.pop();
                featureWrapperSet.add(popedFeatureWrapper);
                FeatureWrapper[] requireFeatures = popedFeatureWrapper.getRequiredFeatures();
                if (requireFeatures == null || requireFeatures.length <= 0) continue;
                for (FeatureWrapper rfw : requireFeatures) {
                    featureWrapperStack.push(rfw);
                }
            }
        }
        return featureWrapperSet.toArray(new FeatureWrapper[0]);
    }
}

