/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.feature.mgt.services.prov;

import java.net.URI;
import java.net.URISyntaxException;
import org.apache.axis2.AxisFault;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.equinox.p2.metadata.ICopyright;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.ILicense;
import org.eclipse.equinox.p2.query.IQueryable;
import org.wso2.carbon.feature.mgt.core.ProvisioningException;
import org.wso2.carbon.feature.mgt.core.util.IUPropertyUtils;
import org.wso2.carbon.feature.mgt.core.util.ProvisioningUtils;
import org.wso2.carbon.feature.mgt.core.util.RepositoryUtils;
import org.wso2.carbon.feature.mgt.services.prov.data.Feature;
import org.wso2.carbon.feature.mgt.services.prov.data.FeatureInfo;
import org.wso2.carbon.feature.mgt.services.prov.data.RepositoryInfo;
import org.wso2.carbon.feature.mgt.services.prov.utils.ProvWSUtils;

public class RepositoryAdminService {
    private static final Log log = LogFactory.getLog(RepositoryAdminService.class);

    public boolean addRepository(String location, String nickName) throws AxisFault {
        try {
            URI uri = new URI(location);
            RepositoryUtils.addRepository((URI)uri, (String)nickName);
        }
        catch (ProvisioningException e) {
            this.handleException(e);
        }
        catch (URISyntaxException e) {
            this.handleException(ProvisioningException.makeExceptionFromErrorCode((String)"invalid.repo.location", (Throwable)e, (Object[])new Object[]{location}));
        }
        return true;
    }

    public void updateRepository(String prevLocation, String prevNickName, String updatedLocation, String updatedNickName) throws AxisFault {
        try {
            URI prevURI = new URI(prevLocation);
            URI updatedURI = new URI(updatedLocation);
            RepositoryUtils.updateRepository((URI)prevURI, (String)prevNickName, (URI)updatedURI, (String)updatedNickName);
        }
        catch (ProvisioningException e) {
            this.handleException(e);
        }
        catch (URISyntaxException e) {
            this.handleException(ProvisioningException.makeExceptionFromErrorCode((String)"invalid.repo.location", (Throwable)e, (Object[])new Object[]{updatedLocation}));
        }
    }

    public void removeRepository(String location) throws AxisFault {
        try {
            URI uri = new URI(location);
            RepositoryUtils.removeRepository((URI)uri);
        }
        catch (ProvisioningException e) {
            this.handleException(e);
        }
        catch (URISyntaxException e) {
            this.handleException(ProvisioningException.makeExceptionFromErrorCode((String)"invalid.repo.location", (Throwable)e, (Object[])new Object[]{location}));
        }
    }

    public void enableRepository(String location, boolean enabled) throws AxisFault {
        try {
            URI uri = new URI(location);
            RepositoryUtils.enableRepository((URI)uri, (boolean)enabled);
        }
        catch (ProvisioningException e) {
            this.handleException(e);
        }
        catch (URISyntaxException e) {
            this.handleException(ProvisioningException.makeExceptionFromErrorCode((String)"invalid.repo.location", (Throwable)e, (Object[])new Object[]{location}));
        }
    }

    public RepositoryInfo[] getEnabledRepositories() throws AxisFault {
        RepositoryInfo[] repositoryInfo = null;
        try {
            URI[] repositoryURIs = RepositoryUtils.getRepositoryList((int)2);
            repositoryInfo = ProvWSUtils.wrapURIsAsRepositories(repositoryURIs);
        }
        catch (ProvisioningException e) {
            this.handleException(e);
        }
        catch (Exception e) {
            this.handleException("Error occured while quering repositories", "failed.get.repositories", e);
        }
        return repositoryInfo;
    }

    public RepositoryInfo[] getAllRepositories() throws AxisFault {
        RepositoryInfo[] repositoryInfo = null;
        try {
            URI[] nonSystemRepoURIs = RepositoryUtils.getRepositoryList((int)2);
            URI[] disabledRepoURIs = RepositoryUtils.getRepositoryList((int)8);
            URI[] allRepoURIs = ProvWSUtils.mergeURIArrays(nonSystemRepoURIs, disabledRepoURIs);
            repositoryInfo = ProvWSUtils.wrapURIsAsRepositories(allRepoURIs);
        }
        catch (ProvisioningException e) {
            this.handleException(e);
        }
        catch (Exception e) {
            this.handleException("Error occured while quering repositories", "failed.get.repositories", e);
        }
        return repositoryInfo;
    }

    public Feature[] getInstallableFeatures(String location, boolean groupByCategory, boolean hideInstalledFeatures, boolean showOnlyTheLatestFeatures) throws AxisFault {
        URI repoURI = null;
        Feature[] features = null;
        IInstallableUnit[] availableInstallableUnits = null;
        try {
            if (location != null) {
                repoURI = new URI(location);
            }
            availableInstallableUnits = groupByCategory ? ProvisioningUtils.getCategoryTypeInstallableUnits((IQueryable)RepositoryUtils.getQuerybleRepositoryManager(repoURI), (boolean)showOnlyTheLatestFeatures).toArray(new IInstallableUnit[0]) : ProvisioningUtils.getGroupTypeInstallableUnits((IQueryable)RepositoryUtils.getQuerybleRepositoryManager(repoURI), (boolean)showOnlyTheLatestFeatures).toArray(new IInstallableUnit[0]);
            IInstallableUnit[] installedInstallableUnits = ProvisioningUtils.getGroupTypeInstallableUnits((IQueryable)ProvisioningUtils.getProfile(), (boolean)false).toArray(new IInstallableUnit[0]);
            features = ProvWSUtils.wrapAvailableFeatures(availableInstallableUnits, installedInstallableUnits, RepositoryUtils.getQuerybleRepositoryManager((URI)repoURI));
        }
        catch (URISyntaxException e) {
            this.handleException("Invalid Repository Location :" + location, "invalid.repo.location", e);
        }
        catch (Exception e) {
            this.handleException("Error occured while quering installable features", "failed.get.installable.features", e);
        }
        return features;
    }

    public FeatureInfo getInstallableFeatureInfo(String featureID, String featureVersion) throws AxisFault {
        FeatureInfo featureInfo = null;
        try {
            IInstallableUnit iu = RepositoryUtils.getInstallableUnit((String)featureID, (String)featureVersion);
            if (iu == null) {
                this.handleException("Error occured while quering feature information :" + featureID + "-" + featureVersion, "failed.get.feature.information");
            }
            ILicense licence = IUPropertyUtils.getLicense((IInstallableUnit)iu);
            ICopyright copyright = IUPropertyUtils.getCopyright((IInstallableUnit)iu);
            featureInfo = ProvWSUtils.wrapIUsAsFeaturesWithDetails(iu, licence, copyright);
        }
        catch (Exception e) {
            this.handleException("Error occured while quering feature information :" + featureID + "-" + featureVersion, "failed.get.feature.information", e);
        }
        return featureInfo;
    }

    private void handleException(String msg, String faultCode, Exception e) throws AxisFault {
        log.error((Object)msg, (Throwable)e);
        throw new AxisFault(msg, faultCode, (Throwable)e);
    }

    private void handleException(String msg, String faultCode) throws AxisFault {
        log.error((Object)msg);
        throw new AxisFault(msg, faultCode);
    }

    private void handleException(ProvisioningException e) throws AxisFault {
        log.error((Object)e.getMessage(), (Throwable)e);
        throw new AxisFault(e.getMessage(), e.getErrorCode());
    }
}

