/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.eventbridge.streamdefn.cassandra.datastore;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import me.prettyprint.cassandra.service.CassandraHostConfigurator;
import me.prettyprint.hector.api.Cluster;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.cassandra.dataaccess.ClusterConfiguration;
import org.wso2.carbon.cassandra.dataaccess.ClusterConfigurationFactory;
import org.wso2.carbon.cassandra.dataaccess.ClusterInformation;
import org.wso2.carbon.cassandra.dataaccess.DataAccessComponentException;
import org.wso2.carbon.eventbridge.commons.Credentials;
import org.wso2.carbon.eventbridge.streamdefn.cassandra.datastore.CassandraConnector;
import org.wso2.carbon.eventbridge.streamdefn.cassandra.internal.util.Utils;

public class ClusterFactory {
    private static LoadingCache<Credentials, Cluster> clusterLoadingCache;
    private static Log log;
    private static final String USERNAME_KEY = "username";
    private static final String PASSWORD_KEY = "password";
    private static final String DEFAULT_HOST = "localhost:9160";
    private static final String LOCAL_HOST_NAME = "localhost";
    private static final String CASSANDRA_COMPONENT_CONF;

    private ClusterFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void init() {
        Class<ClusterFactory> clazz = ClusterFactory.class;
        synchronized (ClusterFactory.class) {
            if (clusterLoadingCache != null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
            clusterLoadingCache = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterAccess(30L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<Credentials, Cluster>(){

                public Cluster load(Credentials credentials) throws Exception {
                    if (log.isTraceEnabled()) {
                        log.trace((Object)("Cache not hit. Loading cluster for user : " + credentials.getUsername()));
                    }
                    ClusterInformation clusterInformation = new ClusterInformation(credentials.getUsername(), credentials.getPassword());
                    Cluster cluster = Utils.getDataAccessService().getCluster(clusterInformation);
                    ClusterFactory.initCassandraKeySpaces(cluster);
                    return cluster;
                }
            });
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public static void initCassandraKeySpaces(Cluster cluster) {
        log.info((Object)"Initializing cluster");
        CassandraConnector connector = Utils.getCassandraConnector();
        connector.createKeySpaceIfNotExisting(cluster, "BAM_AGENT_API_META_DATA");
        connector.createKeySpaceIfNotExisting(cluster, "EVENT_KS");
        connector.createColumnFamily(cluster, "BAM_AGENT_API_META_DATA", "AGENT_STREAM_ID");
        connector.createColumnFamily(cluster, "BAM_AGENT_API_META_DATA", "STREAM_DEF_ID_KEY");
        connector.createColumnFamily(cluster, "BAM_AGENT_API_META_DATA", "STREAM_ID_TO_STREAM_ID_KEY");
        connector.createColumnFamily(cluster, "BAM_AGENT_API_META_DATA", "AGENT_STREAM_DEF");
    }

    private static CassandraHostConfigurator createCassandraHostConfigurator() {
        String cassandraHosts;
        ClusterConfiguration configuration = ClusterConfigurationFactory.create((OMElement)ClusterFactory.loadConfigXML());
        String carbonCassandraRPCPort = System.getProperty("cassandra.rpc_port");
        int cassandraDefaultPort = 0;
        if (carbonCassandraRPCPort != null) {
            cassandraHosts = "localhost:" + carbonCassandraRPCPort;
            cassandraDefaultPort = Integer.parseInt(carbonCassandraRPCPort);
        } else {
            cassandraHosts = configuration.getNodesString();
        }
        if (cassandraHosts == null || "".equals(cassandraHosts)) {
            cassandraHosts = DEFAULT_HOST;
        }
        CassandraHostConfigurator configurator = new CassandraHostConfigurator(cassandraHosts);
        configurator.setAutoDiscoverHosts(configuration.isAutoDiscovery());
        configurator.setAutoDiscoveryDelayInSeconds(configuration.getAutoDiscoveryDelay());
        if (cassandraDefaultPort > 0 && cassandraDefaultPort < 65536) {
            configurator.setPort(cassandraDefaultPort);
        } else {
            configurator.setPort(configuration.getDefaultPort());
        }
        return configurator;
    }

    private static OMElement loadConfigXML() {
        String carbonHome = System.getProperty("carbon.home");
        String path = carbonHome + CASSANDRA_COMPONENT_CONF;
        BufferedInputStream inputStream = null;
        try {
            File file = new File(path);
            if (!file.exists()) {
                log.info((Object)("There is no " + CASSANDRA_COMPONENT_CONF + ". Using the default configuration"));
                inputStream = new BufferedInputStream(new ByteArrayInputStream("<Cassandra/>".getBytes()));
            } else {
                inputStream = new BufferedInputStream(new FileInputStream(file));
            }
            XMLStreamReader parser = XMLInputFactory.newInstance().createXMLStreamReader(inputStream);
            StAXOMBuilder builder = new StAXOMBuilder(parser);
            OMElement oMElement = builder.getDocumentElement();
            return oMElement;
        }
        catch (FileNotFoundException e) {
            throw new DataAccessComponentException(CASSANDRA_COMPONENT_CONF + "cannot be found in the path : " + path, (Throwable)e, log);
        }
        catch (XMLStreamException e) {
            throw new DataAccessComponentException("Invalid XML for " + CASSANDRA_COMPONENT_CONF + " located in " + "the path : " + path, (Throwable)e, log);
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException ingored) {
                log.error((Object)("Cannot close input stream for : " + path));
            }
        }
    }

    public static Cluster getCluster(Credentials credentials) {
        ClusterFactory.init();
        return (Cluster)clusterLoadingCache.getUnchecked((Object)credentials);
    }

    static {
        log = LogFactory.getLog(ClusterFactory.class);
        CASSANDRA_COMPONENT_CONF = File.separator + "repository" + File.separator + "conf" + File.separator + "etc" + File.separator + "cassandra-component.xml";
    }
}

