/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.eventbridge.streamdefn.cassandra.datastore;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import me.prettyprint.cassandra.model.BasicColumnFamilyDefinition;
import me.prettyprint.cassandra.serializers.BooleanSerializer;
import me.prettyprint.cassandra.serializers.ByteBufferSerializer;
import me.prettyprint.cassandra.serializers.DoubleSerializer;
import me.prettyprint.cassandra.serializers.FloatSerializer;
import me.prettyprint.cassandra.serializers.IntegerSerializer;
import me.prettyprint.cassandra.serializers.LongSerializer;
import me.prettyprint.cassandra.serializers.StringSerializer;
import me.prettyprint.cassandra.service.ThriftCfDef;
import me.prettyprint.hector.api.Cluster;
import me.prettyprint.hector.api.Keyspace;
import me.prettyprint.hector.api.Serializer;
import me.prettyprint.hector.api.beans.ColumnSlice;
import me.prettyprint.hector.api.beans.HColumn;
import me.prettyprint.hector.api.beans.OrderedRows;
import me.prettyprint.hector.api.beans.Row;
import me.prettyprint.hector.api.ddl.ColumnFamilyDefinition;
import me.prettyprint.hector.api.ddl.KeyspaceDefinition;
import me.prettyprint.hector.api.factory.HFactory;
import me.prettyprint.hector.api.mutation.Mutator;
import me.prettyprint.hector.api.query.ColumnQuery;
import me.prettyprint.hector.api.query.QueryResult;
import me.prettyprint.hector.api.query.RangeSlicesQuery;
import me.prettyprint.hector.api.query.SliceQuery;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.eventbridge.commons.Attribute;
import org.wso2.carbon.eventbridge.commons.AttributeType;
import org.wso2.carbon.eventbridge.commons.Event;
import org.wso2.carbon.eventbridge.commons.EventStreamDefinition;
import org.wso2.carbon.eventbridge.commons.exception.MalformedStreamDefinitionException;
import org.wso2.carbon.eventbridge.commons.utils.EventDefinitionConverterUtils;
import org.wso2.carbon.eventbridge.core.Utils.EventBridgeUtils;
import org.wso2.carbon.eventbridge.core.exception.EventProcessingException;
import org.wso2.carbon.eventbridge.core.exception.StreamDefinitionStoreException;
import org.wso2.carbon.eventbridge.streamdefn.cassandra.Utils.CassandraSDSUtils;
import org.wso2.carbon.eventbridge.streamdefn.cassandra.datastore.DataType;
import org.wso2.carbon.eventbridge.streamdefn.cassandra.exception.NullValueException;

public class CassandraConnector {
    private static final String STREAM_NAME_KEY = "Name";
    private static final String STREAM_VERSION_KEY = "Version";
    private static final String STREAM_NICK_NAME_KEY = "Nick_Name";
    private static final String STREAM_DESCRIPTION_KEY = "Description";
    public static final String BAM_META_KEYSPACE = "BAM_AGENT_API_META_DATA";
    public static final String BAM_META_STREAM_ID_CF = "AGENT_STREAM_ID";
    public static final String BAM_META_STREAM_DEF_CF = "AGENT_STREAM_DEF";
    public static final String BAM_META_STREAM_ID_KEY_CF = "STREAM_DEF_ID_KEY";
    public static final String BAM_META_STREAMID_TO_STREAM_ID_KEY = "STREAM_ID_TO_STREAM_ID_KEY";
    public static final String BAM_EVENT_DATA_KEYSPACE = "EVENT_KS";
    public static final String BAM_EVENT_DATA_STREAM_DEF_CF = "EVENT_STREAM_DEF";
    private static final String STREAM_ID_KEY = "STREAM_DEF_ID_KEY";
    private static final String STREAM_ID = "STREAM_DEF_ID";
    private static final String STREAM_DEF = "STREAM_DEF";
    private static final StringSerializer stringSerializer = StringSerializer.get();
    private static final IntegerSerializer integerSerializer = IntegerSerializer.get();
    private static final LongSerializer longSerializer = LongSerializer.get();
    private static final BooleanSerializer booleanSerializer = BooleanSerializer.get();
    private static final FloatSerializer floatSerializer = FloatSerializer.get();
    private static final DoubleSerializer doubleSerializer = DoubleSerializer.get();
    private static final ByteBufferSerializer byteBufferSerializer = ByteBufferSerializer.get();
    Log log = LogFactory.getLog(CassandraConnector.class);
    private static final String STREAM_TIMESTAMP_KEY = "Timestamp";

    public void createColumnFamily(Cluster cluster, String keyspaceName, String columnFamilyName) {
        Class<CassandraConnector> clazz = CassandraConnector.class;
        synchronized (CassandraConnector.class) {
            Keyspace keyspace = HFactory.createKeyspace((String)keyspaceName, (Cluster)cluster);
            KeyspaceDefinition keyspaceDef = cluster.describeKeyspace(keyspace.getKeyspaceName());
            List cfDef = keyspaceDef.getCfDefs();
            for (ColumnFamilyDefinition cfdef : cfDef) {
                if (!cfdef.getName().equals(columnFamilyName)) continue;
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)("Column Family " + columnFamilyName + " already exists."));
                }
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return;
            }
            BasicColumnFamilyDefinition columnFamilyDefinition = new BasicColumnFamilyDefinition();
            columnFamilyDefinition.setKeyspaceName(keyspaceName);
            columnFamilyDefinition.setName(columnFamilyName);
            cluster.addColumnFamily((ColumnFamilyDefinition)new ThriftCfDef((ColumnFamilyDefinition)columnFamilyDefinition), true);
            keyspaceDef = cluster.describeKeyspace(keyspace.getKeyspaceName());
            for (int retryCount = 0; retryCount < 100; ++retryCount) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                for (ColumnFamilyDefinition cfdef : keyspaceDef.getCfDefs()) {
                    if (!cfdef.getName().equals(columnFamilyName)) continue;
                    if (this.log.isTraceEnabled()) {
                        this.log.trace((Object)("Column Family " + columnFamilyName + " already exists."));
                    }
                    // ** MonitorExit[var4_4] (shouldn't be in output)
                    return;
                }
            }
            throw new RuntimeException("The column family " + columnFamilyName + " was  not created");
        }
    }

    public boolean createKeySpaceIfNotExisting(Cluster cluster, String keySpaceName) {
        KeyspaceDefinition keySpaceDef = cluster.describeKeyspace(keySpaceName);
        if (keySpaceDef == null) {
            cluster.addKeyspace(HFactory.createKeyspaceDefinition((String)keySpaceName));
            keySpaceDef = cluster.describeKeyspace(keySpaceName);
            int retryCount = 0;
            while (keySpaceDef == null && retryCount < 100) {
                try {
                    Thread.sleep(100L);
                    keySpaceDef = cluster.describeKeyspace(keySpaceName);
                    if (keySpaceDef == null) continue;
                    break;
                }
                catch (InterruptedException e) {
                    // empty catch block
                    break;
                }
            }
            return true;
        }
        return false;
    }

    private Mutator<String> prepareBatchMutate(Attribute attribute, Object[] data, DataType dataType, int eventDataIndex, String rowKey, String streamColumnFamily, Mutator<String> mutator) {
        Long metaVal;
        String columnName = CassandraSDSUtils.getColumnName(dataType, attribute);
        if (attribute.getType().equals((Object)AttributeType.STRING)) {
            String metaVal2 = (String)data[eventDataIndex];
            if (metaVal2 != null && !metaVal2.isEmpty()) {
                mutator.addInsertion((Object)rowKey, streamColumnFamily, HFactory.createColumn((Object)columnName, (Object)metaVal2, (Serializer)stringSerializer, (Serializer)stringSerializer));
            }
        } else if (attribute.getType().equals((Object)AttributeType.INT)) {
            Integer metaVal3 = data[eventDataIndex] instanceof Double ? ((Double)data[eventDataIndex]).intValue() : ((Integer)data[eventDataIndex]).intValue();
            if (metaVal3 != null) {
                mutator.addInsertion((Object)rowKey, streamColumnFamily, HFactory.createColumn((Object)columnName, (Object)metaVal3, (Serializer)stringSerializer, (Serializer)integerSerializer));
            }
        } else if (attribute.getType().equals((Object)AttributeType.FLOAT)) {
            Float metaVal4 = (Float)data[eventDataIndex];
            if (metaVal4 != null) {
                mutator.addInsertion((Object)rowKey, streamColumnFamily, HFactory.createColumn((Object)columnName, (Object)metaVal4, (Serializer)stringSerializer, (Serializer)floatSerializer));
            }
        } else if (attribute.getType().equals((Object)AttributeType.BOOL)) {
            Boolean metaVal5 = (Boolean)data[eventDataIndex];
            if (metaVal5 != null) {
                mutator.addInsertion((Object)rowKey, streamColumnFamily, HFactory.createColumn((Object)columnName, (Object)metaVal5, (Serializer)stringSerializer, (Serializer)booleanSerializer));
            }
        } else if (attribute.getType().equals((Object)AttributeType.DOUBLE)) {
            Double metaVal6 = (Double)data[eventDataIndex];
            if (metaVal6 != null) {
                mutator.addInsertion((Object)rowKey, streamColumnFamily, HFactory.createColumn((Object)columnName, (Object)metaVal6, (Serializer)stringSerializer, (Serializer)doubleSerializer));
            }
        } else if (attribute.getType().equals((Object)AttributeType.LONG) && (metaVal = (Long)data[eventDataIndex]) != null) {
            mutator.addInsertion((Object)rowKey, streamColumnFamily, HFactory.createColumn((Object)columnName, (Object)metaVal, (Serializer)stringSerializer, (Serializer)longSerializer));
        }
        return mutator;
    }

    public String insertEvent(Cluster cluster, Event eventData) throws MalformedStreamDefinitionException, StreamDefinitionStoreException {
        EventStreamDefinition eventStreamDef = this.getStreamDefinitionFromStore(cluster, eventData.getStreamId());
        String streamColumnFamily = this.getCFNameFromStreamId(cluster, eventData.getStreamId());
        if (eventStreamDef == null || streamColumnFamily == null) {
            String errorMsg = "Event stream definition or column family cannot be null";
            this.log.error((Object)errorMsg);
            throw new StreamDefinitionStoreException(errorMsg);
        }
        KeyspaceDefinition keyspaceDefinition = cluster.describeKeyspace(BAM_EVENT_DATA_KEYSPACE);
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Keyspace desc. : " + keyspaceDefinition));
            String CFInfo = "CFs present \n";
            for (ColumnFamilyDefinition columnFamilyDefinition : keyspaceDefinition.getCfDefs()) {
                CFInfo = CFInfo + "cf name : " + columnFamilyDefinition.getName() + "\n";
            }
            this.log.trace((Object)CFInfo);
        }
        Keyspace keyspace = HFactory.createKeyspace((String)BAM_EVENT_DATA_KEYSPACE, (Cluster)cluster);
        Mutator mutator = HFactory.createMutator((Keyspace)keyspace, (Serializer)stringSerializer);
        long timestamp = eventData.getTimeStamp() != 0L ? eventData.getTimeStamp() : System.currentTimeMillis();
        UUID uuid = UUID.randomUUID();
        String rowKey = CassandraSDSUtils.createRowKey(timestamp, uuid);
        mutator.addInsertion((Object)rowKey, streamColumnFamily, HFactory.createStringColumn((String)"STREAM_DEF_ID_KEY", (String)eventStreamDef.getStreamId()));
        mutator.addInsertion((Object)rowKey, streamColumnFamily, HFactory.createStringColumn((String)STREAM_NAME_KEY, (String)eventStreamDef.getName()));
        mutator.addInsertion((Object)rowKey, streamColumnFamily, HFactory.createStringColumn((String)STREAM_VERSION_KEY, (String)eventStreamDef.getVersion()));
        mutator.addInsertion((Object)rowKey, streamColumnFamily, HFactory.createStringColumn((String)STREAM_DESCRIPTION_KEY, (String)eventStreamDef.getDescription()));
        mutator.addInsertion((Object)rowKey, streamColumnFamily, HFactory.createStringColumn((String)STREAM_NICK_NAME_KEY, (String)eventStreamDef.getNickName()));
        mutator.addInsertion((Object)rowKey, streamColumnFamily, HFactory.createColumn((Object)STREAM_TIMESTAMP_KEY, (Object)timestamp, (Serializer)stringSerializer, (Serializer)longSerializer));
        int eventDataIndex = 0;
        if (eventStreamDef.getMetaData() != null) {
            for (Attribute attribute : eventStreamDef.getMetaData()) {
                this.prepareBatchMutate(attribute, eventData.getMetaData(), DataType.meta, eventDataIndex, rowKey, streamColumnFamily, (Mutator<String>)mutator);
                ++eventDataIndex;
            }
        }
        if (eventData.getCorrelationData() != null) {
            eventDataIndex = 0;
            for (Attribute attribute : eventStreamDef.getCorrelationData()) {
                this.prepareBatchMutate(attribute, eventData.getCorrelationData(), DataType.correlation, eventDataIndex, rowKey, streamColumnFamily, (Mutator<String>)mutator);
                ++eventDataIndex;
            }
        }
        if (eventData.getPayloadData() != null) {
            eventDataIndex = 0;
            for (Attribute attribute : eventStreamDef.getPayloadData()) {
                this.prepareBatchMutate(attribute, eventData.getPayloadData(), DataType.payload, eventDataIndex, rowKey, streamColumnFamily, (Mutator<String>)mutator);
                ++eventDataIndex;
            }
        }
        mutator.execute();
        return rowKey;
    }

    public Event getEvent(Cluster cluster, String streamId, String rowKey) throws EventProcessingException {
        EventStreamDefinition streamDefinition;
        try {
            streamDefinition = this.getStreamDefinitionFromStore(cluster, streamId);
        }
        catch (StreamDefinitionStoreException e) {
            String errorMsg = "Error processing stream definition for stream Id : " + streamId;
            this.log.error((Object)errorMsg, (Throwable)e);
            throw new EventProcessingException(errorMsg, (Throwable)e);
        }
        List payloadDefinitions = streamDefinition.getPayloadData();
        List correlationDefinitions = streamDefinition.getCorrelationData();
        List metaDefinitions = streamDefinition.getMetaData();
        SliceQuery sliceQuery = HFactory.createSliceQuery((Keyspace)HFactory.createKeyspace((String)BAM_EVENT_DATA_KEYSPACE, (Cluster)cluster), (Serializer)stringSerializer, (Serializer)stringSerializer, (Serializer)byteBufferSerializer);
        String cfName = this.getCFNameFromStreamId(cluster, streamId);
        sliceQuery.setKey((Object)rowKey).setRange((Object)"", (Object)"", true, Integer.MAX_VALUE).setColumnFamily(cfName);
        ColumnSlice columnSlice = (ColumnSlice)sliceQuery.execute().get();
        Event event = new Event();
        ArrayList<Object> metaData = new ArrayList<Object>();
        ArrayList<Object> correlationData = new ArrayList<Object>();
        ArrayList<Object> payloadData = new ArrayList<Object>();
        try {
            event.setStreamId(CassandraSDSUtils.getString((ByteBuffer)columnSlice.getColumnByName((Object)"STREAM_DEF_ID_KEY").getValue()));
            event.setTimeStamp(CassandraSDSUtils.getLong((ByteBuffer)columnSlice.getColumnByName((Object)STREAM_TIMESTAMP_KEY).getValue()));
            if (payloadDefinitions != null) {
                for (Attribute payloadDefinition : payloadDefinitions) {
                    payloadData.add(this.getValueForDataTypeList((ColumnSlice<String, ByteBuffer>)columnSlice, payloadDefinition, DataType.payload));
                }
            }
            if (metaDefinitions != null) {
                for (Attribute payloadDefinition : metaDefinitions) {
                    metaData.add(this.getValueForDataTypeList((ColumnSlice<String, ByteBuffer>)columnSlice, payloadDefinition, DataType.meta));
                }
            }
            if (correlationDefinitions != null) {
                for (Attribute payloadDefinition : correlationDefinitions) {
                    correlationData.add(correlationData.add(this.getValueForDataTypeList((ColumnSlice<String, ByteBuffer>)columnSlice, payloadDefinition, DataType.correlation)));
                }
            }
        }
        catch (IOException e) {
            String errorMsg = "Error during event data conversions.";
            this.log.error((Object)errorMsg, (Throwable)e);
            throw new EventProcessingException(errorMsg, (Throwable)e);
        }
        Object[] metas = metaDefinitions == null ? null : metaData.toArray();
        Object[] correlations = correlationDefinitions == null ? null : correlationData.toArray();
        Object[] payloads = payloadDefinitions == null ? null : payloadData.toArray();
        event.setMetaData(metas);
        event.setCorrelationData(correlations);
        event.setPayloadData(payloads);
        return event;
    }

    private String getCFNameFromStreamId(Cluster cluster, String streamId) {
        return CassandraSDSUtils.convertStreamNameToCFName(EventBridgeUtils.getStreamNameFromStreamKey((String)this.getStreamKeyFromStreamId(cluster, streamId)));
    }

    private Object getValueForDataTypeList(ColumnSlice<String, ByteBuffer> columnSlice, Attribute payloadDefinition, DataType dataType) throws IOException {
        HColumn eventCol = columnSlice.getColumnByName((Object)CassandraSDSUtils.getColumnName(dataType, payloadDefinition));
        return CassandraSDSUtils.getOriginalValueFromColumnValue((ByteBuffer)eventCol.getValue(), payloadDefinition.getType());
    }

    public String getStreamKeyFromStreamId(Cluster cluster, EventStreamDefinition streamDefinition) {
        return this.getStreamKeyFromStreamId(cluster, streamDefinition.getStreamId());
    }

    public String getStreamKeyFromStreamId(Cluster cluster, String streamId) {
        try {
            return StreamKeyCache.getStreamKeyFromStreamId(cluster, streamId);
        }
        catch (ExecutionException e) {
            return null;
        }
    }

    public void saveStreamDefinitionToStore(Cluster cluster, EventStreamDefinition eventStreamDefinition) {
        this.saveStreamDefinitionToStore(cluster, eventStreamDefinition.getStreamId(), eventStreamDefinition);
    }

    public void saveStreamDefinitionToStore(Cluster cluster, String streamId, EventStreamDefinition eventStreamDefinition) {
        Keyspace keyspace = HFactory.createKeyspace((String)BAM_META_KEYSPACE, (Cluster)cluster);
        this.createColumnFamily(cluster, BAM_EVENT_DATA_KEYSPACE, EventBridgeUtils.getStreamNameFromStreamKey((String)CassandraSDSUtils.convertStreamNameToCFName(EventBridgeUtils.getStreamNameFromStreamKey((String)this.getStreamKeyFromStreamId(cluster, streamId)))));
        Mutator mutator = HFactory.createMutator((Keyspace)keyspace, (Serializer)stringSerializer);
        mutator.addInsertion((Object)streamId, BAM_META_STREAM_DEF_CF, HFactory.createStringColumn((String)STREAM_DEF, (String)EventDefinitionConverterUtils.convertToJson((EventStreamDefinition)eventStreamDefinition)));
        mutator.execute();
        this.log.info((Object)("Saving Stream Definition : " + eventStreamDefinition));
        if (this.log.isTraceEnabled()) {
            String logMsg = "saveStreamDefinition executed. \n";
            try {
                EventStreamDefinition streamDefinitionFromStore = this.getStreamDefinitionFromStore(cluster, streamId);
                logMsg = logMsg + " stream definition saved : " + streamDefinitionFromStore.toString() + " \n";
            }
            catch (StreamDefinitionStoreException e) {
                this.log.error((Object)e.getErrorMessage(), (Throwable)e);
            }
            this.log.trace((Object)logMsg);
        }
    }

    public void saveStreamIdToStore(Cluster cluster, EventStreamDefinition eventStreamDefinition) {
        this.saveStreamIdToStore(cluster, EventBridgeUtils.constructStreamKey((String)eventStreamDefinition.getName(), (String)eventStreamDefinition.getVersion()), eventStreamDefinition.getStreamId());
    }

    public void saveStreamIdToStore(Cluster cluster, String streamIdKey, String streamId) {
        Keyspace keyspace = HFactory.createKeyspace((String)BAM_META_KEYSPACE, (Cluster)cluster);
        Mutator mutator = HFactory.createMutator((Keyspace)keyspace, (Serializer)stringSerializer);
        mutator.addInsertion((Object)streamId, "STREAM_DEF_ID_KEY", HFactory.createStringColumn((String)"STREAM_DEF_ID_KEY", (String)streamIdKey));
        mutator.addInsertion((Object)streamIdKey, BAM_META_STREAM_ID_CF, HFactory.createStringColumn((String)STREAM_ID, (String)streamId));
        mutator.execute();
        if (this.log.isTraceEnabled()) {
            String logMsg = "saveStreamID executed. \n";
            String streamIdFromStore = this.getStreamIdFromStore(cluster, streamIdKey);
            logMsg = logMsg + " stream id saved : " + streamIdFromStore + " \n";
            this.log.trace((Object)logMsg);
        }
    }

    public String getStreamIdFromStore(Cluster cluster, EventStreamDefinition streamDefinition) {
        String streamIdKey = EventBridgeUtils.constructStreamKey((String)streamDefinition.getName(), (String)streamDefinition.getVersion());
        return this.getStreamIdFromStore(cluster, streamIdKey);
    }

    public String getStreamIdFromStore(Cluster cluster, String streamIdKey) {
        try {
            return StreamIdCache.getStreamIdFromStreamKey(cluster, streamIdKey);
        }
        catch (ExecutionException e) {
            return null;
        }
    }

    public EventStreamDefinition getStreamDefinitionFromStore(Cluster cluster, String streamId) throws StreamDefinitionStoreException {
        try {
            return StreamDefnCache.getStreamDefinition(cluster, streamId);
        }
        catch (ExecutionException e) {
            return null;
        }
    }

    public Collection<EventStreamDefinition> getAllStreamDefinitionFromStore(Cluster cluster) throws StreamDefinitionStoreException {
        ArrayList<EventStreamDefinition> eventStreamDefinitions = new ArrayList<EventStreamDefinition>();
        Keyspace keyspace = HFactory.createKeyspace((String)BAM_META_KEYSPACE, (Cluster)cluster);
        ColumnQuery columnQuery = HFactory.createStringColumnQuery((Keyspace)keyspace);
        RangeSlicesQuery query = HFactory.createRangeSlicesQuery((Keyspace)keyspace, (Serializer)stringSerializer, (Serializer)stringSerializer, (Serializer)stringSerializer);
        query.setColumnFamily(BAM_META_STREAM_ID_CF);
        query.setKeys((Object)"", (Object)"");
        query.setColumnNames((Object[])new String[]{STREAM_ID});
        QueryResult result = query.execute();
        String logMsg = null;
        if (this.log.isTraceEnabled()) {
            logMsg = "getAllStreamDefinitions called : \n";
        }
        for (Row row : (OrderedRows)result.get()) {
            String streamId;
            EventStreamDefinition streamDefinitionFromStore;
            if (row == null || (streamDefinitionFromStore = this.getStreamDefinitionFromStore(cluster, streamId = (String)row.getColumnSlice().getColumnByName((Object)STREAM_ID).getValue())) == null) continue;
            eventStreamDefinitions.add(streamDefinitionFromStore);
            if (!this.log.isTraceEnabled()) continue;
            logMsg = logMsg + "Stream definitions with stream id : " + streamDefinitionFromStore.getStreamId() + " found. Stream Definition is : " + streamDefinitionFromStore.toString() + " \n";
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)logMsg);
        }
        return eventStreamDefinitions;
    }

    public void insertEventDefinition(Cluster cluster, EventStreamDefinition eventStreamDefinition) {
        Keyspace keyspace = HFactory.createKeyspace((String)BAM_EVENT_DATA_KEYSPACE, (Cluster)cluster);
        Mutator mutator = HFactory.createMutator((Keyspace)keyspace, (Serializer)new StringSerializer());
        mutator.addInsertion((Object)eventStreamDefinition.getStreamId(), BAM_EVENT_DATA_STREAM_DEF_CF, HFactory.createStringColumn((String)STREAM_DEF, (String)EventDefinitionConverterUtils.convertToJson((EventStreamDefinition)eventStreamDefinition)));
        mutator.execute();
    }

    private static class StreamDefnCache {
        private static LoadingCache<StreamIdClusterBean, EventStreamDefinition> streamDefnCache = null;

        private StreamDefnCache() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static void init() {
            Class<StreamDefnCache> clazz = StreamDefnCache.class;
            synchronized (StreamDefnCache.class) {
                if (streamDefnCache != null) {
                    // ** MonitorExit[var0] (shouldn't be in output)
                    return;
                }
                streamDefnCache = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterAccess(30L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<StreamIdClusterBean, EventStreamDefinition>(){

                    public EventStreamDefinition load(StreamIdClusterBean streamIdClusterBean) throws Exception {
                        Keyspace keyspace = HFactory.createKeyspace((String)CassandraConnector.BAM_META_KEYSPACE, (Cluster)streamIdClusterBean.getCluster());
                        ColumnQuery columnQuery = HFactory.createStringColumnQuery((Keyspace)keyspace);
                        columnQuery.setColumnFamily(CassandraConnector.BAM_META_STREAM_DEF_CF).setKey((Object)streamIdClusterBean.getStreamId()).setName((Object)CassandraConnector.STREAM_DEF);
                        QueryResult result = columnQuery.execute();
                        HColumn hColumn = (HColumn)result.get();
                        try {
                            if (hColumn != null) {
                                return EventDefinitionConverterUtils.convertFromJson((String)((String)hColumn.getValue()));
                            }
                        }
                        catch (MalformedStreamDefinitionException e) {
                            throw new StreamDefinitionStoreException("Retrieved definition from Cassandra store is malformed. Retrieved value : " + (String)hColumn.getValue());
                        }
                        throw new NullValueException("No value found");
                    }
                });
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
        }

        public static EventStreamDefinition getStreamDefinition(Cluster cluster, String streamId) throws ExecutionException {
            StreamDefnCache.init();
            return (EventStreamDefinition)streamDefnCache.get((Object)new StreamIdClusterBean(cluster, streamId));
        }

        private static class StreamIdClusterBean {
            private Cluster cluster;
            private String streamId;

            private StreamIdClusterBean(Cluster cluster, String streamId) {
                this.cluster = cluster;
                this.streamId = streamId;
            }

            public Cluster getCluster() {
                return this.cluster;
            }

            public String getStreamId() {
                return this.streamId;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                StreamIdClusterBean that = (StreamIdClusterBean)o;
                if (!this.cluster.equals(that.cluster)) {
                    return false;
                }
                return this.streamId.equals(that.streamId);
            }

            public int hashCode() {
                int result = this.cluster.hashCode();
                result = 31 * result + this.streamId.hashCode();
                return result;
            }
        }
    }

    private static class StreamIdCache {
        private static LoadingCache<StreamKeyClusterBean, String> streamIdCache = null;

        private StreamIdCache() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static void init() {
            Class<StreamIdCache> clazz = StreamIdCache.class;
            synchronized (StreamIdCache.class) {
                if (streamIdCache != null) {
                    // ** MonitorExit[var0] (shouldn't be in output)
                    return;
                }
                streamIdCache = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterAccess(30L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<StreamKeyClusterBean, String>(){

                    public String load(StreamKeyClusterBean streamKeyClusterBean) throws Exception {
                        Keyspace keyspace = HFactory.createKeyspace((String)CassandraConnector.BAM_META_KEYSPACE, (Cluster)streamKeyClusterBean.getCluster());
                        ColumnQuery columnQuery = HFactory.createStringColumnQuery((Keyspace)keyspace);
                        columnQuery.setColumnFamily(CassandraConnector.BAM_META_STREAM_ID_CF).setKey((Object)streamKeyClusterBean.getStreamKey()).setName((Object)CassandraConnector.STREAM_ID);
                        QueryResult result = columnQuery.execute();
                        HColumn hColumn = (HColumn)result.get();
                        if (hColumn != null) {
                            return (String)hColumn.getValue();
                        }
                        throw new NullValueException("No value found");
                    }
                });
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
        }

        public static String getStreamIdFromStreamKey(Cluster cluster, String streamKey) throws ExecutionException {
            StreamIdCache.init();
            return (String)streamIdCache.get((Object)new StreamKeyClusterBean(cluster, streamKey));
        }

        private static class StreamKeyClusterBean {
            private Cluster cluster;
            private String streamKey;

            private StreamKeyClusterBean(Cluster cluster, String streamKey) {
                this.cluster = cluster;
                this.streamKey = streamKey;
            }

            public Cluster getCluster() {
                return this.cluster;
            }

            public String getStreamKey() {
                return this.streamKey;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                StreamKeyClusterBean that = (StreamKeyClusterBean)o;
                if (!this.cluster.equals(that.cluster)) {
                    return false;
                }
                return this.streamKey.equals(that.streamKey);
            }

            public int hashCode() {
                int result = this.cluster.hashCode();
                result = 31 * result + this.streamKey.hashCode();
                return result;
            }
        }
    }

    private static class StreamKeyCache {
        private static LoadingCache<StreamIdClusterBean, String> streamKeyCache = null;

        private StreamKeyCache() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static void init() {
            Class<StreamKeyCache> clazz = StreamKeyCache.class;
            synchronized (StreamKeyCache.class) {
                if (streamKeyCache != null) {
                    // ** MonitorExit[var0] (shouldn't be in output)
                    return;
                }
                streamKeyCache = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterAccess(30L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<StreamIdClusterBean, String>(){

                    public String load(StreamIdClusterBean streamIdClusterBean) throws Exception {
                        Keyspace keyspace = HFactory.createKeyspace((String)CassandraConnector.BAM_META_KEYSPACE, (Cluster)streamIdClusterBean.getCluster());
                        ColumnQuery columnQuery = HFactory.createStringColumnQuery((Keyspace)keyspace).setColumnFamily("STREAM_DEF_ID_KEY").setKey((Object)streamIdClusterBean.getStreamId()).setName((Object)"STREAM_DEF_ID_KEY");
                        HColumn queryResult = (HColumn)columnQuery.execute().get();
                        if (queryResult != null) {
                            return (String)queryResult.getValue();
                        }
                        throw new NullValueException("No value found");
                    }
                });
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
        }

        public static String getStreamKeyFromStreamId(Cluster cluster, String streamId) throws ExecutionException {
            StreamKeyCache.init();
            return (String)streamKeyCache.get((Object)new StreamIdClusterBean(cluster, streamId));
        }

        private static class StreamIdClusterBean {
            private Cluster cluster;
            private String streamId;

            private StreamIdClusterBean(Cluster cluster, String streamId) {
                this.cluster = cluster;
                this.streamId = streamId;
            }

            public Cluster getCluster() {
                return this.cluster;
            }

            public String getStreamId() {
                return this.streamId;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                StreamIdClusterBean that = (StreamIdClusterBean)o;
                if (!this.cluster.equals(that.cluster)) {
                    return false;
                }
                return this.streamId.equals(that.streamId);
            }

            public int hashCode() {
                int result = this.cluster.hashCode();
                result = 31 * result + this.streamId.hashCode();
                return result;
            }
        }
    }
}

