/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.eventbridge.receiver.thrift.service;

import org.apache.thrift.TException;
import org.wso2.carbon.eventbridge.commons.exception.AuthenticationException;
import org.wso2.carbon.eventbridge.commons.exception.DifferentStreamDefinitionAlreadyDefinedException;
import org.wso2.carbon.eventbridge.commons.exception.MalformedStreamDefinitionException;
import org.wso2.carbon.eventbridge.commons.exception.NoStreamDefinitionExistException;
import org.wso2.carbon.eventbridge.commons.exception.SessionTimeoutException;
import org.wso2.carbon.eventbridge.commons.exception.UndefinedEventTypeException;
import org.wso2.carbon.eventbridge.commons.thrift.data.ThriftEventBundle;
import org.wso2.carbon.eventbridge.commons.thrift.exception.ThriftAuthenticationException;
import org.wso2.carbon.eventbridge.commons.thrift.exception.ThriftDifferentStreamDefinitionAlreadyDefinedException;
import org.wso2.carbon.eventbridge.commons.thrift.exception.ThriftMalformedStreamDefinitionException;
import org.wso2.carbon.eventbridge.commons.thrift.exception.ThriftNoStreamDefinitionExistException;
import org.wso2.carbon.eventbridge.commons.thrift.exception.ThriftSessionExpiredException;
import org.wso2.carbon.eventbridge.commons.thrift.exception.ThriftUndefinedEventTypeException;
import org.wso2.carbon.eventbridge.commons.thrift.service.secure.ThriftSecureEventTransmissionService;
import org.wso2.carbon.eventbridge.core.EventBridgeReceiverService;
import org.wso2.carbon.eventbridge.core.EventConverter;
import org.wso2.carbon.eventbridge.receiver.thrift.converter.ThriftEventConverter;

public class ThriftSecureEventTransmissionServiceImpl
implements ThriftSecureEventTransmissionService.Iface {
    private EventBridgeReceiverService eventBridgeReceiverService;
    private EventConverter eventConverter = new ThriftEventConverter();

    public ThriftSecureEventTransmissionServiceImpl(EventBridgeReceiverService eventBridgeReceiverService) {
        this.eventBridgeReceiverService = eventBridgeReceiverService;
    }

    public String connect(String username, String password) throws ThriftAuthenticationException {
        try {
            return this.eventBridgeReceiverService.login(username, password);
        }
        catch (AuthenticationException e) {
            throw new ThriftAuthenticationException(e.getErrorMessage());
        }
    }

    public void disconnect(String sessionId) throws TException {
        try {
            this.eventBridgeReceiverService.logout(sessionId);
        }
        catch (Exception e) {
            throw new TException(e.getMessage());
        }
    }

    public String defineEventStream(String sessionId, String streamDefinition) throws TException, ThriftSessionExpiredException, ThriftDifferentStreamDefinitionAlreadyDefinedException, ThriftMalformedStreamDefinitionException {
        try {
            return this.eventBridgeReceiverService.defineEventStream(sessionId, streamDefinition);
        }
        catch (DifferentStreamDefinitionAlreadyDefinedException e) {
            throw new ThriftDifferentStreamDefinitionAlreadyDefinedException(e.getErrorMessage());
        }
        catch (MalformedStreamDefinitionException e) {
            throw new ThriftMalformedStreamDefinitionException(e.getErrorMessage());
        }
        catch (SessionTimeoutException e) {
            throw new ThriftSessionExpiredException(e.getErrorMessage());
        }
    }

    public String findEventStreamId(String sessionId, String streamName, String streamVersion) throws ThriftNoStreamDefinitionExistException, ThriftSessionExpiredException, TException {
        try {
            return this.eventBridgeReceiverService.findEventStreamId(sessionId, streamName, streamVersion);
        }
        catch (NoStreamDefinitionExistException e) {
            throw new ThriftNoStreamDefinitionExistException(e.getErrorMessage());
        }
        catch (SessionTimeoutException e) {
            throw new ThriftSessionExpiredException(e.getErrorMessage());
        }
    }

    public void publish(ThriftEventBundle eventBundle) throws ThriftUndefinedEventTypeException, ThriftSessionExpiredException, TException {
        try {
            this.eventBridgeReceiverService.publish((Object)eventBundle, eventBundle.getSessionId(), this.eventConverter);
        }
        catch (UndefinedEventTypeException e) {
            throw new ThriftUndefinedEventTypeException(e.getErrorMessage());
        }
        catch (SessionTimeoutException e) {
            throw new ThriftSessionExpiredException(e.getErrorMessage());
        }
    }
}

