/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.eventbridge.receiver.thrift.internal.utils;

import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.base.api.ServerConfigurationService;
import org.wso2.carbon.eventbridge.receiver.thrift.conf.ThriftEventReceiverConfiguration;

public final class ThriftEventReceiverBuilder {
    private static final Log log = LogFactory.getLog(ThriftEventReceiverBuilder.class);

    private ThriftEventReceiverBuilder() {
    }

    private static void populatePorts(OMElement config, int portOffset, ThriftEventReceiverConfiguration thriftEventReceiverConfiguration) {
        OMElement receiverPort;
        OMElement secureEventReceiverPort = config.getFirstChildWithName(new QName("http://wso2.org/carbon/eventbridge", "securePort"));
        if (secureEventReceiverPort != null) {
            try {
                thriftEventReceiverConfiguration.setSecureEventReceiverPort(Integer.parseInt(secureEventReceiverPort.getText()) + portOffset);
            }
            catch (NumberFormatException ignored) {
                // empty catch block
            }
        }
        if ((receiverPort = config.getFirstChildWithName(new QName("http://wso2.org/carbon/eventbridge", "port"))) != null) {
            try {
                thriftEventReceiverConfiguration.setEventReceiverPort(Integer.parseInt(receiverPort.getText()) + portOffset);
            }
            catch (NumberFormatException ignored) {
                // empty catch block
            }
        }
    }

    public static int readPortOffset(ServerConfigurationService serverConfiguration) {
        String portOffset = serverConfiguration.getFirstProperty("Ports.Offset");
        try {
            return portOffset != null ? Integer.parseInt(portOffset.trim()) : 0;
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public static void populateConfigurations(int portOffset, ThriftEventReceiverConfiguration thriftEventReceiverConfiguration, OMElement initialConfig) {
        OMElement thriftReceiverConfig;
        if (initialConfig != null && (thriftReceiverConfig = initialConfig.getFirstChildWithName(new QName("http://wso2.org/carbon/eventbridge", "thriftEventReceiver"))) != null) {
            ThriftEventReceiverBuilder.populatePorts(thriftReceiverConfig, portOffset, thriftEventReceiverConfiguration);
        }
    }
}

