/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.eventbridge.receiver.thrift.internal;

import java.net.MalformedURLException;
import java.net.URL;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.service.component.ComponentContext;
import org.wso2.carbon.base.api.ServerConfigurationService;
import org.wso2.carbon.eventbridge.core.EventBridgeReceiverService;
import org.wso2.carbon.eventbridge.core.exception.EventBridgeException;
import org.wso2.carbon.eventbridge.receiver.thrift.ThriftEventReceiverFactory;
import org.wso2.carbon.eventbridge.receiver.thrift.conf.ThriftEventReceiverConfiguration;
import org.wso2.carbon.eventbridge.receiver.thrift.internal.ThriftEventReceiver;
import org.wso2.carbon.eventbridge.receiver.thrift.internal.utils.ThriftEventReceiverBuilder;
import org.wso2.carbon.utils.CarbonUtils;
import org.wso2.carbon.utils.ConfigurationContextService;

public class ThriftEventReceiverDS {
    private static final Log log = LogFactory.getLog(ThriftEventReceiverDS.class);
    private EventBridgeReceiverService eventBridgeReceiverService;
    private ServerConfigurationService serverConfiguration;
    private ConfigurationContextService configurationContext;
    private ThriftEventReceiver eventReceiver;

    protected void activate(ComponentContext context) {
        block6: {
            try {
                int portOffset = ThriftEventReceiverBuilder.readPortOffset(this.serverConfiguration);
                ThriftEventReceiverConfiguration thriftEventReceiverConfiguration = new ThriftEventReceiverConfiguration(7711 + portOffset, 7611 + portOffset);
                ThriftEventReceiverBuilder.populateConfigurations(portOffset, thriftEventReceiverConfiguration, this.eventBridgeReceiverService.getInitialConfig());
                if (this.eventReceiver != null) break block6;
                this.eventReceiver = new ThriftEventReceiverFactory().createAgentServer(thriftEventReceiverConfiguration, this.eventBridgeReceiverService);
                String serverUrl = CarbonUtils.getServerURL((ServerConfigurationService)this.serverConfiguration, (ConfigurationContext)this.configurationContext.getServerConfigContext());
                String hostName = null;
                try {
                    hostName = new URL(serverUrl).getHost();
                }
                catch (MalformedURLException e) {
                    log.warn((Object)("The server url :" + serverUrl + " is malformed URL hence hostname is assigned as 'localhost'"));
                    hostName = "localhost";
                }
                this.eventReceiver.start(hostName);
                log.info((Object)"Successfully deployed Agent Server ");
            }
            catch (EventBridgeException e) {
                log.error((Object)"Can not create and start Agent Server ", (Throwable)e);
            }
            catch (RuntimeException e) {
                log.error((Object)"Error in starting Agent Server ", (Throwable)e);
            }
            catch (Throwable e) {
                log.error((Object)"Error in starting Agent Server ", e);
            }
        }
    }

    protected void deactivate(ComponentContext context) {
        this.eventReceiver.stop();
        if (log.isDebugEnabled()) {
            log.debug((Object)"Successfully stopped agent server");
        }
    }

    protected void setServerConfiguration(ServerConfigurationService serverConfiguration) {
        this.serverConfiguration = serverConfiguration;
    }

    protected void unsetServerConfiguration(ServerConfigurationService serverConfiguration) {
        this.serverConfiguration = null;
    }

    protected void setConfigurationContext(ConfigurationContextService configurationContext) {
        this.configurationContext = configurationContext;
    }

    protected void unsetConfigurationContext(ConfigurationContextService configurationContext) {
        this.configurationContext = null;
    }

    protected void setEventBridgeReceiverService(EventBridgeReceiverService eventBridgeReceiverService) {
        this.eventBridgeReceiverService = eventBridgeReceiverService;
    }

    protected void unsetEventBridgeReceiverService(EventBridgeReceiverService eventBridgeReceiverService) {
        this.eventBridgeReceiverService = null;
    }
}

