/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.eventbridge.receiver.thrift.internal;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.thrift.TProcessor;
import org.apache.thrift.server.TServer;
import org.apache.thrift.server.TThreadPoolServer;
import org.apache.thrift.transport.TSSLTransportFactory;
import org.apache.thrift.transport.TServerSocket;
import org.apache.thrift.transport.TServerTransport;
import org.apache.thrift.transport.TTransportException;
import org.wso2.carbon.base.ServerConfiguration;
import org.wso2.carbon.eventbridge.commons.exception.TransportException;
import org.wso2.carbon.eventbridge.commons.thrift.service.general.ThriftEventTransmissionService;
import org.wso2.carbon.eventbridge.commons.thrift.service.secure.ThriftSecureEventTransmissionService;
import org.wso2.carbon.eventbridge.core.EventBridgeReceiverService;
import org.wso2.carbon.eventbridge.core.exception.EventBridgeException;
import org.wso2.carbon.eventbridge.receiver.thrift.conf.ThriftEventReceiverConfiguration;
import org.wso2.carbon.eventbridge.receiver.thrift.service.ThriftEventTransmissionServiceImpl;
import org.wso2.carbon.eventbridge.receiver.thrift.service.ThriftSecureEventTransmissionServiceImpl;

public class ThriftEventReceiver {
    private static final Log log = LogFactory.getLog(ThriftEventReceiver.class);
    private EventBridgeReceiverService eventBridgeReceiverService;
    private ThriftEventReceiverConfiguration thriftEventReceiverConfiguration;
    private TServer authenticationServer;
    private TServer eventReceiverServer;

    public ThriftEventReceiver(int secureReceiverPort, int receiverPort, EventBridgeReceiverService eventBridgeReceiverService) {
        this.eventBridgeReceiverService = eventBridgeReceiverService;
        this.thriftEventReceiverConfiguration = new ThriftEventReceiverConfiguration(secureReceiverPort, receiverPort);
    }

    public ThriftEventReceiver(int receiverPort, EventBridgeReceiverService eventBridgeReceiverService) {
        this.eventBridgeReceiverService = eventBridgeReceiverService;
        this.thriftEventReceiverConfiguration = new ThriftEventReceiverConfiguration(receiverPort + 100, receiverPort);
    }

    public ThriftEventReceiver(ThriftEventReceiverConfiguration thriftEventReceiverConfiguration, EventBridgeReceiverService eventBridgeReceiverService) {
        this.eventBridgeReceiverService = eventBridgeReceiverService;
        this.thriftEventReceiverConfiguration = thriftEventReceiverConfiguration;
    }

    public void start(String hostName) throws EventBridgeException {
        this.startSecureEventTransmission(hostName, this.thriftEventReceiverConfiguration.getSecureEventReceiverPort(), this.eventBridgeReceiverService);
        this.startEventTransmission(this.thriftEventReceiverConfiguration.getEventReceiverPort(), this.eventBridgeReceiverService);
    }

    private void startSecureEventTransmission(String hostName, int port, EventBridgeReceiverService eventBridgeReceiverService) throws EventBridgeException {
        try {
            ServerConfiguration serverConfig = ServerConfiguration.getInstance();
            String keyStore = serverConfig.getFirstProperty("Security.KeyStore.Location");
            if (keyStore == null && (keyStore = System.getProperty("Security.KeyStore.Location")) == null) {
                throw new EventBridgeException("Cannot start agent server, not valid Security.KeyStore.Location is null");
            }
            String keyStorePassword = serverConfig.getFirstProperty("Security.KeyStore.Password");
            if (keyStorePassword == null && (keyStorePassword = System.getProperty("Security.KeyStore.Password")) == null) {
                throw new EventBridgeException("Cannot start agent server, not valid Security.KeyStore.Password is null ");
            }
            this.startSecureEventTransmission(hostName, port, keyStore, keyStorePassword, eventBridgeReceiverService);
        }
        catch (TransportException e) {
            throw new EventBridgeException("Cannot start agent server on port " + port, (Throwable)e);
        }
        catch (UnknownHostException e) {
            // empty catch block
        }
    }

    protected void startSecureEventTransmission(String hostName, int port, String keyStore, String keyStorePassword, EventBridgeReceiverService eventBridgeReceiverService) throws TransportException, UnknownHostException {
        TServerSocket serverTransport;
        TSSLTransportFactory.TSSLTransportParameters params = new TSSLTransportFactory.TSSLTransportParameters();
        params.setKeyStore(keyStore, keyStorePassword);
        try {
            serverTransport = TSSLTransportFactory.getServerSocket((int)port, (int)30000, (InetAddress)InetAddress.getByName(hostName), (TSSLTransportFactory.TSSLTransportParameters)params);
        }
        catch (TTransportException e) {
            throw new TransportException("Thrift transport exception occurred ", (Throwable)e);
        }
        ThriftSecureEventTransmissionService.Processor processor = new ThriftSecureEventTransmissionService.Processor((ThriftSecureEventTransmissionService.Iface)new ThriftSecureEventTransmissionServiceImpl(eventBridgeReceiverService));
        this.authenticationServer = new TThreadPoolServer((TThreadPoolServer.Args)new TThreadPoolServer.Args((TServerTransport)serverTransport).processor((TProcessor)processor));
        Thread thread = new Thread(new ServerThread(this.authenticationServer));
        log.info((Object)("Thrift SSL port : " + port));
        thread.start();
    }

    protected void startEventTransmission(int port, EventBridgeReceiverService eventBridgeReceiverService) throws EventBridgeException {
        try {
            TServerSocket serverTransport = new TServerSocket(port);
            ThriftEventTransmissionService.Processor processor = new ThriftEventTransmissionService.Processor((ThriftEventTransmissionService.Iface)new ThriftEventTransmissionServiceImpl(eventBridgeReceiverService));
            this.eventReceiverServer = new TThreadPoolServer((TThreadPoolServer.Args)new TThreadPoolServer.Args((TServerTransport)serverTransport).processor((TProcessor)processor));
            Thread thread = new Thread(new ServerThread(this.eventReceiverServer));
            log.info((Object)("Thrift port : " + port));
            thread.start();
        }
        catch (TTransportException e) {
            throw new EventBridgeException("Cannot start Thrift server on port " + port, (Throwable)e);
        }
    }

    public void stop() {
        this.authenticationServer.stop();
        this.eventReceiverServer.stop();
    }

    static class ServerThread
    implements Runnable {
        private TServer server;

        ServerThread(TServer server) {
            this.server = server;
        }

        @Override
        public void run() {
            this.server.serve();
        }
    }
}

