/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.eventbridge.commons.utils;

import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.wso2.carbon.eventbridge.commons.Attribute;
import org.wso2.carbon.eventbridge.commons.AttributeType;
import org.wso2.carbon.eventbridge.commons.EventStreamDefinition;
import org.wso2.carbon.eventbridge.commons.exception.MalformedStreamDefinitionException;

public final class EventDefinitionConverterUtils {
    public static final String nullString = "_null";
    private static Gson gson = new Gson();

    private EventDefinitionConverterUtils() {
    }

    public static AttributeType[] generateAttributeTypeArray(List<Attribute> attributes) {
        if (attributes != null) {
            AttributeType[] attributeTypes = new AttributeType[attributes.size()];
            int metaDataSize = attributes.size();
            for (int i = 0; i < metaDataSize; ++i) {
                Attribute attribute = attributes.get(i);
                attributeTypes[i] = attribute.getType();
            }
            return attributeTypes;
        }
        return null;
    }

    public static EventStreamDefinition convertFromJson(String streamDefinition) throws MalformedStreamDefinitionException {
        try {
            EventStreamDefinition tempEventStreamDefinition = (EventStreamDefinition)gson.fromJson(streamDefinition.replaceAll("(?i)int", "INT").replaceAll("(?i)long", "LONG").replaceAll("(?i)float", "FLOAT").replaceAll("(?i)double", "DOUBLE").replaceAll("(?i)bool", "BOOL").replaceAll("(?i)string", "STRING"), EventStreamDefinition.class);
            String name = tempEventStreamDefinition.getName();
            String version = tempEventStreamDefinition.getVersion();
            if (version == null) {
                version = "1.0.0";
            }
            if (name == null) {
                throw new MalformedStreamDefinitionException("stream name is null");
            }
            String streamId = tempEventStreamDefinition.getStreamId();
            EventStreamDefinition eventStreamDefinition = streamId == null ? new EventStreamDefinition(name, version) : new EventStreamDefinition(name, version, streamId);
            eventStreamDefinition.setTags(tempEventStreamDefinition.getTags());
            eventStreamDefinition.setMetaData(tempEventStreamDefinition.getMetaData());
            eventStreamDefinition.setCorrelationData(tempEventStreamDefinition.getCorrelationData());
            eventStreamDefinition.setPayloadData(tempEventStreamDefinition.getPayloadData());
            eventStreamDefinition.setNickName(tempEventStreamDefinition.getNickName());
            eventStreamDefinition.setDescription(tempEventStreamDefinition.getDescription());
            eventStreamDefinition.setDescription(tempEventStreamDefinition.getDescription());
            eventStreamDefinition.setTags(tempEventStreamDefinition.getTags());
            return eventStreamDefinition;
        }
        catch (RuntimeException e) {
            throw new MalformedStreamDefinitionException(" Malformed stream definition " + streamDefinition, e);
        }
    }

    public static String convertToJson(List<EventStreamDefinition> existingDefinitions) {
        JSONArray jsonDefnArray = new JSONArray();
        for (EventStreamDefinition existingDefinition : existingDefinitions) {
            jsonDefnArray.put((Object)EventDefinitionConverterUtils.convertToJson(existingDefinition));
        }
        return gson.toJson(existingDefinitions);
    }

    public static List<EventStreamDefinition> convertMultipleEventDefns(String jsonArrayOfEventDefns) throws MalformedStreamDefinitionException {
        try {
            JSONArray jsonArray = new JSONArray(jsonArrayOfEventDefns);
            ArrayList<EventStreamDefinition> eventStreamDefinitions = new ArrayList<EventStreamDefinition>();
            for (int i = 0; i < jsonArray.length(); ++i) {
                eventStreamDefinitions.add(EventDefinitionConverterUtils.convertFromJson(jsonArray.getString(i)));
            }
            return eventStreamDefinitions;
        }
        catch (JSONException e) {
            throw new MalformedStreamDefinitionException(" Malformed stream definition " + jsonArrayOfEventDefns, e);
        }
    }

    public static String convertToJson(EventStreamDefinition existingDefinition) {
        return gson.toJson((Object)existingDefinition);
    }
}

