/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.eventbridge.agent.thrift.internal.publisher.authenticator;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.pool.impl.GenericKeyedObjectPool;
import org.apache.thrift.TException;
import org.wso2.carbon.eventbridge.agent.thrift.exception.AgentAuthenticatorException;
import org.wso2.carbon.eventbridge.agent.thrift.internal.publisher.authenticator.AgentAuthenticator;
import org.wso2.carbon.eventbridge.commons.exception.AuthenticationException;
import org.wso2.carbon.eventbridge.commons.thrift.exception.ThriftAuthenticationException;
import org.wso2.carbon.eventbridge.commons.thrift.service.secure.ThriftSecureEventTransmissionService;

public class ThriftAgentAuthenticator
extends AgentAuthenticator {
    private static Log log = LogFactory.getLog(ThriftAgentAuthenticator.class);

    public ThriftAgentAuthenticator(GenericKeyedObjectPool secureTransportPool) {
        super(secureTransportPool);
    }

    @Override
    protected String connect(Object client, String userName, String password) throws AuthenticationException, AgentAuthenticatorException {
        try {
            return ((ThriftSecureEventTransmissionService.Client)client).connect(userName, password);
        }
        catch (ThriftAuthenticationException e) {
            throw new AuthenticationException("Thrift Authentication Exception", (Throwable)e);
        }
        catch (TException e) {
            throw new AgentAuthenticatorException("Thrift exception", e);
        }
    }

    @Override
    protected void disconnect(Object client, String sessionId) throws AgentAuthenticatorException {
        try {
            ((ThriftSecureEventTransmissionService.Client)client).disconnect(sessionId);
        }
        catch (TException e) {
            throw new AgentAuthenticatorException("Thrift Exception", e);
        }
    }
}

