/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.eventbridge.agent.thrift.internal.pool.client.secure;

import org.apache.commons.pool.BaseKeyedPoolableObjectFactory;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TSSLTransportFactory;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;
import org.wso2.carbon.eventbridge.agent.thrift.exception.AgentSecurityException;
import org.wso2.carbon.eventbridge.commons.thrift.service.secure.ThriftSecureEventTransmissionService;

public class SecureClientPoolFactory
extends BaseKeyedPoolableObjectFactory {
    private TSSLTransportFactory.TSSLTransportParameters params;
    private String trustStorePassword;
    private String trustStore;

    public SecureClientPoolFactory(String trustStorePassword, String trustStore) {
        this.trustStorePassword = trustStorePassword;
        this.trustStore = trustStore;
    }

    public ThriftSecureEventTransmissionService.Client makeObject(Object key) throws AgentSecurityException, TTransportException {
        if (this.params == null) {
            if (this.trustStore == null) {
                this.trustStore = System.getProperty("javax.net.ssl.trustStore");
                if (this.trustStore == null) {
                    throw new AgentSecurityException("No trustStore found");
                }
            }
            if (this.trustStorePassword == null) {
                this.trustStorePassword = System.getProperty("javax.net.ssl.trustStorePassword");
                if (this.trustStorePassword == null) {
                    throw new AgentSecurityException("No trustStore password found");
                }
            }
            this.params = new TSSLTransportFactory.TSSLTransportParameters();
            this.params.setTrustStore(this.trustStore, this.trustStorePassword);
        }
        String[] hostNameAndPort = key.toString().split(",")[1].split(":");
        TSocket receiverTransport = TSSLTransportFactory.getClientSocket((String)hostNameAndPort[0], (int)Integer.parseInt(hostNameAndPort[1]), (int)0, (TSSLTransportFactory.TSSLTransportParameters)this.params);
        TBinaryProtocol protocol = new TBinaryProtocol((TTransport)receiverTransport);
        return new ThriftSecureEventTransmissionService.Client((TProtocol)protocol);
    }

    public boolean validateObject(Object key, Object obj) {
        ThriftSecureEventTransmissionService.Client client = (ThriftSecureEventTransmissionService.Client)obj;
        return client.getOutputProtocol().getTransport().isOpen();
    }
}

