/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.eventbridge.agent.thrift.internal.publisher.client;

import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.pool.impl.GenericKeyedObjectPool;
import org.apache.thrift.TException;
import org.wso2.carbon.eventbridge.agent.thrift.conf.DataPublisherConfiguration;
import org.wso2.carbon.eventbridge.agent.thrift.exception.EventPublisherException;
import org.wso2.carbon.eventbridge.agent.thrift.internal.EventQueue;
import org.wso2.carbon.eventbridge.agent.thrift.internal.publisher.authenticator.AgentAuthenticator;
import org.wso2.carbon.eventbridge.agent.thrift.internal.publisher.client.EventPublisher;
import org.wso2.carbon.eventbridge.agent.thrift.internal.utils.ThriftEventConverter;
import org.wso2.carbon.eventbridge.commons.Event;
import org.wso2.carbon.eventbridge.commons.exception.DifferentStreamDefinitionAlreadyDefinedException;
import org.wso2.carbon.eventbridge.commons.exception.MalformedStreamDefinitionException;
import org.wso2.carbon.eventbridge.commons.exception.NoStreamDefinitionExistException;
import org.wso2.carbon.eventbridge.commons.exception.SessionTimeoutException;
import org.wso2.carbon.eventbridge.commons.exception.StreamDefinitionException;
import org.wso2.carbon.eventbridge.commons.exception.UndefinedEventTypeException;
import org.wso2.carbon.eventbridge.commons.thrift.data.ThriftEventBundle;
import org.wso2.carbon.eventbridge.commons.thrift.exception.ThriftDifferentStreamDefinitionAlreadyDefinedException;
import org.wso2.carbon.eventbridge.commons.thrift.exception.ThriftMalformedStreamDefinitionException;
import org.wso2.carbon.eventbridge.commons.thrift.exception.ThriftNoStreamDefinitionExistException;
import org.wso2.carbon.eventbridge.commons.thrift.exception.ThriftSessionExpiredException;
import org.wso2.carbon.eventbridge.commons.thrift.exception.ThriftStreamDefinitionException;
import org.wso2.carbon.eventbridge.commons.thrift.exception.ThriftUndefinedEventTypeException;
import org.wso2.carbon.eventbridge.commons.thrift.service.general.ThriftEventTransmissionService;
import org.wso2.carbon.eventbridge.commons.thrift.service.secure.ThriftSecureEventTransmissionService;

public class ThriftEventPublisher
extends EventPublisher {
    private static Log log = LogFactory.getLog(ThriftEventPublisher.class);

    public ThriftEventPublisher(EventQueue<Event> eventQueue, GenericKeyedObjectPool transportPool, Semaphore queueSemaphore, int maxMessageBundleSize, DataPublisherConfiguration dataPublisherConfiguration, AgentAuthenticator agentAuthenticator, ThreadPoolExecutor threadPool) {
        super(eventQueue, transportPool, queueSemaphore, maxMessageBundleSize, dataPublisherConfiguration, agentAuthenticator, threadPool);
    }

    @Override
    protected int getNumberOfEvents(Object eventBundle) {
        return ((ThriftEventBundle)eventBundle).getEventNum();
    }

    @Override
    protected ThriftEventBundle convertToEventBundle(Object eventBundle, Event event, String sessionId) {
        return ThriftEventConverter.toThriftEventBundle(event, (ThriftEventBundle)eventBundle, sessionId);
    }

    @Override
    protected void setSessionId(Object eventBundle, String sessionId) {
        ((ThriftEventBundle)eventBundle).setSessionId(sessionId);
    }

    @Override
    protected String getSessionId(Object eventBundle) {
        return ((ThriftEventBundle)eventBundle).getSessionId();
    }

    @Override
    void publish(Object client, Object eventBundle) throws UndefinedEventTypeException, SessionTimeoutException, EventPublisherException {
        try {
            if (client instanceof ThriftSecureEventTransmissionService.Client) {
                ((ThriftSecureEventTransmissionService.Client)client).publish((ThriftEventBundle)eventBundle);
            } else {
                ((ThriftEventTransmissionService.Client)client).publish((ThriftEventBundle)eventBundle);
            }
        }
        catch (ThriftUndefinedEventTypeException e) {
            throw new UndefinedEventTypeException("Thrift Undefined Event Type Exception ", (Throwable)e);
        }
        catch (ThriftSessionExpiredException e) {
            throw new SessionTimeoutException("Thrift Session Expired Exception ", (Throwable)e);
        }
        catch (TException e) {
            throw new EventPublisherException("Cannot send Events", e);
        }
    }

    @Override
    protected String defineEventStream(Object client, String sessionId, String eventStreamDefinition) throws DifferentStreamDefinitionAlreadyDefinedException, MalformedStreamDefinitionException, EventPublisherException, SessionTimeoutException, StreamDefinitionException {
        try {
            if (client instanceof ThriftSecureEventTransmissionService.Client) {
                return ((ThriftSecureEventTransmissionService.Client)client).defineEventStream(sessionId, eventStreamDefinition);
            }
            return ((ThriftEventTransmissionService.Client)client).defineEventStream(sessionId, eventStreamDefinition);
        }
        catch (ThriftDifferentStreamDefinitionAlreadyDefinedException e) {
            throw new DifferentStreamDefinitionAlreadyDefinedException("Thrift Different Stream Definition Already Defined ", (Throwable)e);
        }
        catch (ThriftMalformedStreamDefinitionException e) {
            throw new MalformedStreamDefinitionException("Malformed Stream Definition ", (Throwable)e);
        }
        catch (ThriftStreamDefinitionException e) {
            throw new StreamDefinitionException("Thrift Stream Definition Exception ", (Throwable)e);
        }
        catch (ThriftSessionExpiredException e) {
            throw new SessionTimeoutException("Session Expired ", (Throwable)e);
        }
        catch (TException e) {
            throw new EventPublisherException("TException ", e);
        }
    }

    @Override
    protected String findEventStreamId(Object client, String currentSessionId, String name, String version) throws NoStreamDefinitionExistException, SessionTimeoutException, EventPublisherException {
        try {
            if (client instanceof ThriftSecureEventTransmissionService.Client) {
                return ((ThriftSecureEventTransmissionService.Client)client).findEventStreamId(currentSessionId, name, version);
            }
            return ((ThriftEventTransmissionService.Client)client).findEventStreamId(currentSessionId, name, version);
        }
        catch (ThriftNoStreamDefinitionExistException e) {
            throw new NoStreamDefinitionExistException("Thrift No Stream Definition Exist", (Throwable)e);
        }
        catch (ThriftSessionExpiredException e) {
            throw new SessionTimeoutException("Session Expired ", (Throwable)e);
        }
        catch (TException e) {
            throw new EventPublisherException("Thrift Exception", e);
        }
    }
}

