/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.eventbridge.agent.thrift.internal;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.wso2.carbon.eventbridge.agent.thrift.Agent;
import org.wso2.carbon.eventbridge.agent.thrift.conf.AgentConfiguration;
import org.wso2.carbon.eventbridge.agent.thrift.internal.utils.AgentBuilder;

public class AgentDS {
    private static Log log = LogFactory.getLog(AgentDS.class);
    private Agent agent;
    private ServiceRegistration serviceRegistration;

    protected void activate(ComponentContext context) {
        if (this.agent == null) {
            AgentConfiguration agentConfiguration = new AgentConfiguration();
            this.agent = new Agent(AgentBuilder.loadAgentConfiguration(agentConfiguration));
            this.serviceRegistration = context.getBundleContext().registerService(Agent.class.getName(), (Object)this.agent, null);
            log.info((Object)"Successfully deployed Agent Client");
        }
    }

    protected void deactivate(ComponentContext context) {
        context.getBundleContext().ungetService(this.serviceRegistration.getReference());
        this.agent.shutdown();
        if (log.isDebugEnabled()) {
            log.debug((Object)"Successfully stopped agent");
        }
    }
}

