/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.eventbridge.agent.thrift;

import com.google.gson.Gson;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import org.wso2.carbon.eventbridge.agent.thrift.Agent;
import org.wso2.carbon.eventbridge.agent.thrift.conf.DataPublisherConfiguration;
import org.wso2.carbon.eventbridge.agent.thrift.conf.ReceiverConfiguration;
import org.wso2.carbon.eventbridge.agent.thrift.exception.AgentException;
import org.wso2.carbon.eventbridge.agent.thrift.internal.EventQueue;
import org.wso2.carbon.eventbridge.agent.thrift.internal.publisher.client.EventPublisher;
import org.wso2.carbon.eventbridge.agent.thrift.internal.publisher.client.EventPublisherFactory;
import org.wso2.carbon.eventbridge.agent.thrift.internal.utils.AgentServerURL;
import org.wso2.carbon.eventbridge.commons.Event;
import org.wso2.carbon.eventbridge.commons.EventStreamDefinition;
import org.wso2.carbon.eventbridge.commons.exception.AuthenticationException;
import org.wso2.carbon.eventbridge.commons.exception.DifferentStreamDefinitionAlreadyDefinedException;
import org.wso2.carbon.eventbridge.commons.exception.MalformedStreamDefinitionException;
import org.wso2.carbon.eventbridge.commons.exception.NoStreamDefinitionExistException;
import org.wso2.carbon.eventbridge.commons.exception.StreamDefinitionException;
import org.wso2.carbon.eventbridge.commons.exception.TransportException;

public class DataPublisher {
    private Agent agent;
    private DataPublisherConfiguration dataPublisherConfiguration;
    private EventPublisher eventPublisher;
    private EventQueue<Event> eventQueue;
    private Gson gson = new Gson();
    private ThreadPoolExecutor threadPool;

    public DataPublisher(String receiverUrl, String userName, String password) throws MalformedURLException, AgentException, AuthenticationException, TransportException {
        this(receiverUrl, userName, password, new Agent());
    }

    public DataPublisher(String authenticationUrl, String receiverUrl, String userName, String password) throws MalformedURLException, AgentException, AuthenticationException, TransportException {
        this(authenticationUrl, receiverUrl, userName, password, new Agent());
    }

    public DataPublisher(String receiverUrl, String userName, String password, Agent agent) throws MalformedURLException, AgentException, AuthenticationException, TransportException {
        AgentServerURL receiverURL = new AgentServerURL(receiverUrl);
        if (receiverURL.isSecured()) {
            this.start(new ReceiverConfiguration(userName, password, receiverURL.getHost(), receiverURL.getPort(), receiverURL.getHost(), receiverURL.getPort(), receiverURL.isSecured()), agent);
        } else {
            this.start(new ReceiverConfiguration(userName, password, receiverURL.getHost(), receiverURL.getPort(), receiverURL.getHost(), receiverURL.getPort() + 100, receiverURL.isSecured()), agent);
        }
    }

    public DataPublisher(String authenticationUrl, String receiverUrl, String userName, String password, Agent agent) throws MalformedURLException, AgentException, AuthenticationException, TransportException {
        AgentServerURL authenticationURL = new AgentServerURL(authenticationUrl);
        if (!authenticationURL.isSecured()) {
            throw new MalformedURLException("Authentication url protocol is not ssl, expected = ssl://<HOST>:<PORT> but actual = " + authenticationUrl);
        }
        AgentServerURL receiverURL = new AgentServerURL(receiverUrl);
        this.start(new ReceiverConfiguration(userName, password, receiverURL.getHost(), receiverURL.getPort(), authenticationURL.getHost(), authenticationURL.getPort(), receiverURL.isSecured()), agent);
    }

    public void setAgent(Agent agent) throws AgentException, AuthenticationException, TransportException {
        this.agent.shutdown(this);
        this.start(this.dataPublisherConfiguration.getReceiverConfiguration(), agent);
    }

    public Agent getAgent() {
        return this.agent;
    }

    private void start(ReceiverConfiguration receiverConfiguration, Agent agent) throws AgentException, AuthenticationException, TransportException {
        agent.addDataPublisher(this);
        this.agent = agent;
        this.dataPublisherConfiguration = new DataPublisherConfiguration(receiverConfiguration);
        this.eventQueue = new EventQueue();
        this.threadPool = agent.getThreadPool();
        this.eventPublisher = receiverConfiguration.isDataTransferSecured() ? EventPublisherFactory.getEventPublisher(this.dataPublisherConfiguration, this.eventQueue, agent, agent.getSecureTransportPool()) : EventPublisherFactory.getEventPublisher(this.dataPublisherConfiguration, this.eventQueue, agent, agent.getTransportPool());
        this.dataPublisherConfiguration.setSessionId(agent.getAgentAuthenticator().connect(this.dataPublisherConfiguration));
    }

    public String defineEventStream(String eventStreamDefinition) throws AgentException, MalformedStreamDefinitionException, StreamDefinitionException, DifferentStreamDefinitionAlreadyDefinedException {
        String sessionId = this.dataPublisherConfiguration.getSessionId();
        return this.eventPublisher.defineEventStream(sessionId, eventStreamDefinition);
    }

    public String defineEventStream(EventStreamDefinition eventStreamDefinition) throws AgentException, MalformedStreamDefinitionException, StreamDefinitionException, DifferentStreamDefinitionAlreadyDefinedException {
        String sessionId = this.dataPublisherConfiguration.getSessionId();
        String streamId = this.eventPublisher.defineEventStream(sessionId, this.gson.toJson((Object)eventStreamDefinition));
        try {
            Field field = EventStreamDefinition.class.getDeclaredField("streamId");
            field.setAccessible(true);
            field.set(eventStreamDefinition, streamId);
        }
        catch (NoSuchFieldException e) {
        }
        catch (IllegalAccessException e) {
            // empty catch block
        }
        return streamId;
    }

    public String findEventStream(String name, String version) throws AgentException, StreamDefinitionException, NoStreamDefinitionExistException {
        String sessionId = this.dataPublisherConfiguration.getSessionId();
        return this.eventPublisher.findEventStreamId(sessionId, name, version);
    }

    public void publish(Event event) throws AgentException {
        try {
            this.agent.getQueueSemaphore().acquire();
            if (!this.eventQueue.put(event)) {
                try {
                    this.threadPool.submit(this.eventPublisher);
                }
                catch (RejectedExecutionException ignored) {}
            }
        }
        catch (InterruptedException e) {
            throw new AgentException("Cannot add " + event + " to event queue", e);
        }
    }

    public void publish(String streamId, Object[] metaDataArray, Object[] correlationDataArray, Object[] payloadDataArray) throws AgentException {
        this.publish(new Event(streamId, System.currentTimeMillis(), metaDataArray, correlationDataArray, payloadDataArray));
    }

    public void publish(String streamId, long timeStamp, Object[] metaDataArray, Object[] correlationDataArray, Object[] payloadDataArray) throws AgentException {
        this.publish(new Event(streamId, timeStamp, metaDataArray, correlationDataArray, payloadDataArray));
    }

    public void stop() {
        this.agent.getAgentAuthenticator().disconnect(this.dataPublisherConfiguration);
        this.agent.shutdown(this);
    }
}

