/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.ui;

import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.um.ws.api.stub.RemoteAuthorizationManagerServiceStub;
import org.wso2.carbon.um.ws.api.stub.UserStoreExceptionException;
import org.wso2.carbon.user.mgt.common.FlaggedName;
import org.wso2.carbon.user.mgt.ui.UserAdminClient;

public class AuthUtils {
    private static final Log log = LogFactory.getLog(AuthUtils.class);
    List<String> rolesWithAccess = new ArrayList<String>();
    List<String> usersWithAccess = new ArrayList<String>();
    List<String> rolesWithoutAccess = new ArrayList<String>();
    List<String> usersWithoutAccess = new ArrayList<String>();
    private UserAdminClient userAdminClient;
    private RemoteAuthorizationManagerServiceStub authClient;

    public AuthUtils(String resourceName, UserAdminClient userAdminClient, RemoteAuthorizationManagerServiceStub authClient) throws Exception {
        String[] allUsers;
        this.userAdminClient = userAdminClient;
        this.authClient = authClient;
        FlaggedName[] allRoles = userAdminClient.getAllRolesNames();
        if (resourceName != null && resourceName.trim().length() > 0) {
            String[] rolesList = authClient.getAllowedRolesForResource(resourceName, "write");
            String[] usersList = authClient.getExplicitlyAllowedUsersForResource(resourceName, "write");
            if (rolesList != null) {
                for (String role : rolesList) {
                    this.rolesWithAccess.add(role);
                }
            }
            if (usersList != null) {
                for (String user : usersList) {
                    this.usersWithAccess.add(user);
                }
            }
        }
        for (FlaggedName name : allRoles) {
            if (this.rolesWithAccess.contains(name.getItemName())) continue;
            this.rolesWithoutAccess.add(name.getItemName());
        }
        for (String name : allUsers = userAdminClient.listUsers(null)) {
            if (this.usersWithAccess.contains(name)) continue;
            this.usersWithoutAccess.add(name);
        }
    }

    public List<String> getRolesWithAccess() {
        return this.rolesWithAccess;
    }

    public void setRolesWithAccess(List<String> rolesWithAccess) {
        this.rolesWithAccess = rolesWithAccess;
    }

    public List<String> getUsersWithAccess() {
        return this.usersWithAccess;
    }

    public void setUsersWithAccess(List<String> usersWithAccess) {
        this.usersWithAccess = usersWithAccess;
    }

    public List<String> getRolesWithoutAccess() {
        return this.rolesWithoutAccess;
    }

    public void setRolesWithoutAccess(List<String> rolesWithoutAccess) {
        this.rolesWithoutAccess = rolesWithoutAccess;
    }

    public List<String> getUsersWithoutAccess() {
        return this.usersWithoutAccess;
    }

    public void setUsersWithoutAccess(List<String> usersWithoutAccess) {
        this.usersWithoutAccess = usersWithoutAccess;
    }

    public String updatePermissions(String resourcePath, String actorsToAddAsStr, String actorsToRemoveAsStr) throws RemoteException, UserStoreExceptionException {
        String msg;
        String[] removeTokens;
        String party;
        String[] addTokens;
        StringBuffer updateMessages = new StringBuffer();
        ArrayList<String> addRolesList = new ArrayList<String>(3);
        ArrayList<String> addUsersList = new ArrayList<String>(3);
        ArrayList<String> removeRolesList = new ArrayList<String>(3);
        ArrayList<String> removeUsersList = new ArrayList<String>(3);
        if (actorsToAddAsStr != null && actorsToAddAsStr.trim().length() > 0 && (addTokens = actorsToAddAsStr.split("#")) != null) {
            for (String token : addTokens) {
                if (token.trim().length() <= 0) continue;
                party = token.substring(0, token.indexOf("("));
                if (token.contains("(U)")) {
                    addUsersList.add(party);
                    continue;
                }
                addRolesList.add(party);
            }
        }
        if (actorsToRemoveAsStr != null && actorsToRemoveAsStr.trim().length() > 0 && (removeTokens = actorsToRemoveAsStr.split("#")) != null) {
            for (String token : removeTokens) {
                if (token.trim().length() <= 0) continue;
                party = token.substring(0, token.indexOf("("));
                if (token.contains("(U)")) {
                    removeUsersList.add(party);
                    continue;
                }
                removeRolesList.add(party);
            }
        }
        if (addUsersList.size() > 0) {
            for (String user : addUsersList) {
                this.authClient.authorizeUser(user, resourcePath, "write");
            }
            msg = "Authorized " + addUsersList + " to access " + resourcePath;
            log.info((Object)msg);
            updateMessages.append(msg);
        }
        if (addRolesList.size() > 0) {
            for (String role : addRolesList) {
                this.authClient.authorizeRole(role, resourcePath, "write");
            }
            msg = "Authorized " + addRolesList + " to access " + resourcePath;
            log.info((Object)msg);
            updateMessages.append(msg);
        }
        if (removeUsersList.size() > 0) {
            for (String user : removeUsersList) {
                this.authClient.clearUserAuthorization(user, resourcePath, "write");
            }
            msg = "Deny " + removeUsersList + " to access " + resourcePath;
            log.info((Object)msg);
            updateMessages.append(msg);
        }
        if (removeRolesList.size() > 0) {
            for (String role : removeRolesList) {
                this.authClient.clearRoleAuthorization(role, resourcePath, "write");
            }
            msg = "Deny " + removeRolesList + " to access " + resourcePath;
            log.info((Object)msg);
            updateMessages.append(msg);
        }
        return updateMessages.toString();
    }
}

