/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.ui;

import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.context.ConfigurationContext;
import org.wso2.carbon.event.client.broker.BrokerClient;
import org.wso2.carbon.ui.CarbonUIUtil;
import org.wso2.carbon.um.ws.api.stub.RemoteAuthorizationManagerServiceStub;
import org.wso2.carbon.user.mgt.ui.UserAdminClient;

public class UIUtils {
    public static RemoteAuthorizationManagerServiceStub getAuthManagementClient(ServletConfig config, HttpSession session, HttpServletRequest request) throws AxisFault {
        String backendServerURL = CarbonUIUtil.getServerURL((ServletContext)config.getServletContext(), (HttpSession)session);
        backendServerURL = backendServerURL + "RemoteAuthorizationManagerService";
        String cookie = (String)session.getAttribute("wso2carbon.admin.service.cookie");
        RemoteAuthorizationManagerServiceStub stub = new RemoteAuthorizationManagerServiceStub(backendServerURL);
        if (cookie != null) {
            Options option = stub._getServiceClient().getOptions();
            option.setManageSession(true);
            option.setProperty("Cookie", (Object)cookie);
        }
        return stub;
    }

    public static BrokerClient getBrokerClient(ServletConfig config, HttpSession session, HttpServletRequest request) {
        String backendServerURL = CarbonUIUtil.getServerURL((ServletContext)config.getServletContext(), (HttpSession)session);
        ConfigurationContext configContext = (ConfigurationContext)config.getServletContext().getAttribute("ConfigurationContext");
        backendServerURL = backendServerURL + "EventBrokerService";
        String cookie = (String)session.getAttribute("wso2carbon.admin.service.cookie");
        return new BrokerClient(configContext, backendServerURL, cookie);
    }

    public static String getBackendServerUrl(ServletConfig config, HttpSession session, HttpServletRequest request) {
        return CarbonUIUtil.getServerURL((ServletContext)config.getServletContext(), (HttpSession)session);
    }

    public static UserAdminClient getUserAdminClient(ServletConfig config, HttpSession session, HttpServletRequest request) throws Exception {
        String backendServerURL = CarbonUIUtil.getServerURL((ServletContext)config.getServletContext(), (HttpSession)session);
        if (!backendServerURL.endsWith("/")) {
            backendServerURL = backendServerURL + "/";
        }
        String cookie = (String)session.getAttribute("wso2carbon.admin.service.cookie");
        return new UserAdminClient(cookie, backendServerURL, null);
    }

    public static String getValue(HttpServletRequest request, String name) {
        String value = request.getParameter(name);
        if ("null".equals(value)) {
            return "";
        }
        return value != null ? value : "";
    }

    public static String getDialog(String message) {
        return "CARBON.showErrorDialog('" + message + "');";
    }

    public static String getSubscriptionMode(String serverMode) {
        if (serverMode.equals("mode_1")) {
            return "Immediate Children";
        }
        if (serverMode.equals("mode_2")) {
            return "Topic and Children";
        }
        return "Topic Only";
    }
}

