/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.core.internal.subscription.registry;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.axis2.databinding.utils.ConverterUtil;
import org.wso2.carbon.event.core.exception.EventBrokerConfigurationException;
import org.wso2.carbon.event.core.exception.EventBrokerException;
import org.wso2.carbon.event.core.internal.util.EventBrokerHolder;
import org.wso2.carbon.event.core.internal.util.JavaUtil;
import org.wso2.carbon.event.core.subscription.Subscription;
import org.wso2.carbon.event.core.subscription.SubscriptionManager;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.user.api.UserRealm;
import org.wso2.carbon.user.api.UserStoreException;

public class RegistrySubscriptionManager
implements SubscriptionManager {
    private RegistryService registryService = EventBrokerHolder.getInstance().getRegistryService();
    private String topicStoragePath;
    private String indexStoragePath;

    public RegistrySubscriptionManager(String topicStoragePath, String indexStoragePath) throws EventBrokerConfigurationException {
        this.topicStoragePath = topicStoragePath;
        this.indexStoragePath = indexStoragePath;
        try {
            UserRegistry userRegistry = this.registryService.getGovernanceSystemRegistry(EventBrokerHolder.getInstance().getTenantId());
            if (!userRegistry.resourceExists(this.topicStoragePath)) {
                userRegistry.put(this.topicStoragePath, (Resource)userRegistry.newCollection());
            }
            UserRealm userRealm = EventBrokerHolder.getInstance().getRealmService().getTenantUserRealm(EventBrokerHolder.getInstance().getTenantId());
            for (String role : userRealm.getUserStoreManager().getRoleNames()) {
                userRealm.getAuthorizationManager().authorizeRole(role, this.topicStoragePath, "subscribe");
                userRealm.getAuthorizationManager().authorizeRole(role, this.topicStoragePath, "publish");
            }
            if (!userRegistry.resourceExists(this.indexStoragePath)) {
                userRegistry.put(this.indexStoragePath, userRegistry.newResource());
            }
        }
        catch (RegistryException e) {
            throw new EventBrokerConfigurationException("Can not access the registry ", e);
        }
        catch (UserStoreException e) {
            throw new EventBrokerConfigurationException("Can not access the user registry", e);
        }
    }

    @Override
    public void addSubscription(Subscription subscription) throws EventBrokerException {
        try {
            Resource topicIndexResource;
            UserRegistry userRegistry = this.registryService.getGovernanceSystemRegistry(EventBrokerHolder.getInstance().getTenantId());
            String resourcePath = this.getResourcePath(subscription.getId(), subscription.getTopicName());
            Resource resource = userRegistry.newResource();
            resource.setProperty("subscriptionURL", subscription.getEventSinkURL());
            resource.setProperty("eventDispatcherName", subscription.getEventDispatcherName());
            if (subscription.getExpires() != null) {
                resource.setProperty("expires", ConverterUtil.convertToString((Calendar)subscription.getExpires()));
            }
            resource.setProperty("owner", subscription.getOwner());
            resource.setProperty("topicName", subscription.getTopicName());
            resource.setProperty("createdTime", System.currentTimeMillis() + "");
            resource.setProperty("mode", JavaUtil.getSubscriptionMode(subscription.getTopicName()));
            Map<String, String> properties = subscription.getProperties();
            for (String key : properties.keySet()) {
                resource.setProperty(key, properties.get(key));
            }
            userRegistry.put(resourcePath, resource);
            String fullPath = this.indexStoragePath;
            if (userRegistry.resourceExists(fullPath)) {
                topicIndexResource = userRegistry.get(fullPath);
                topicIndexResource.addProperty(subscription.getId(), subscription.getTopicName());
            } else {
                topicIndexResource = userRegistry.newResource();
                topicIndexResource.addProperty(subscription.getId(), subscription.getTopicName());
            }
            userRegistry.put(fullPath, topicIndexResource);
        }
        catch (RegistryException e) {
            throw new EventBrokerException("Can not save to registry ", e);
        }
    }

    private String getResourcePath(String subscriptionID, String topicName) {
        String resourcePath = this.topicStoragePath;
        if (!(topicName = topicName.replaceAll("\\.", "/")).startsWith("/")) {
            resourcePath = resourcePath + "/";
        }
        if (topicName.indexOf("*") > -1) {
            topicName = topicName.substring(0, topicName.indexOf("*"));
        } else if (topicName.indexOf("#") > -1) {
            topicName = topicName.substring(0, topicName.indexOf("#"));
        }
        resourcePath = resourcePath + topicName;
        if (!resourcePath.endsWith("/")) {
            resourcePath = resourcePath + "/";
        }
        resourcePath = resourcePath + "ws.subscriptions/" + subscriptionID;
        return resourcePath;
    }

    @Override
    public List<Subscription> getAllSubscriptions() throws EventBrokerException {
        ArrayList<Subscription> subscriptions = new ArrayList<Subscription>();
        try {
            UserRegistry userRegistry = this.registryService.getGovernanceSystemRegistry(EventBrokerHolder.getInstance().getTenantId());
            if (userRegistry.resourceExists(this.indexStoragePath)) {
                Resource topicIndexResource = userRegistry.get(this.indexStoragePath);
                Properties savedSubscriptions = topicIndexResource.getProperties();
                Resource subscriptionResource = null;
                Subscription subscription = null;
                String subscriptionID = null;
                String topicName = null;
                Enumeration<?> e = savedSubscriptions.propertyNames();
                while (e.hasMoreElements()) {
                    subscriptionID = (String)e.nextElement();
                    if (subscriptionID.startsWith("registry")) continue;
                    topicName = topicIndexResource.getProperty(subscriptionID);
                    subscriptionResource = userRegistry.get(this.getResourcePath(subscriptionID, topicName));
                    subscription = JavaUtil.getSubscription(subscriptionResource);
                    subscription.setId(subscriptionID);
                    subscription.setTopicName(topicName);
                    subscription.setTenantId(EventBrokerHolder.getInstance().getTenantId());
                    subscriptions.add(subscription);
                }
            }
        }
        catch (RegistryException e) {
            throw new EventBrokerException("Can not access the registry ", e);
        }
        return subscriptions;
    }

    @Override
    public Subscription getSubscription(String id) throws EventBrokerException {
        try {
            UserRegistry userRegistry = this.registryService.getGovernanceSystemRegistry(EventBrokerHolder.getInstance().getTenantId());
            Resource topicIndexResource = userRegistry.get(this.indexStoragePath);
            String subscriptionPath = this.getResourcePath(id, topicIndexResource.getProperty(id));
            if (subscriptionPath != null) {
                Resource subscriptionResource = userRegistry.get(subscriptionPath);
                Subscription subscription = JavaUtil.getSubscription(subscriptionResource);
                subscription.setTenantId(EventBrokerHolder.getInstance().getTenantId());
                return subscription;
            }
            return null;
        }
        catch (RegistryException e) {
            throw new EventBrokerException("Can not access the registry ", e);
        }
    }

    @Override
    public void renewSubscription(Subscription subscription) throws EventBrokerException {
        try {
            Resource subscriptionResource;
            UserRegistry userRegistry = this.registryService.getGovernanceSystemRegistry(EventBrokerHolder.getInstance().getTenantId());
            Resource topicIndexResource = userRegistry.get(this.indexStoragePath);
            String topicName = topicIndexResource.getProperty(subscription.getId());
            String subscriptionPath = this.getResourcePath(subscription.getId(), topicName);
            if (subscriptionPath != null) {
                subscriptionResource = userRegistry.get(subscriptionPath);
                if (subscription.getExpires() != null) {
                    subscriptionResource.setProperty("expires", ConverterUtil.convertToString((Calendar)subscription.getExpires()));
                }
                Subscription currentSubscription = JavaUtil.getSubscription(subscriptionResource);
                subscription.setTopicName(currentSubscription.getTopicName());
                Map<String, String> properties = currentSubscription.getProperties();
                for (String key : properties.keySet()) {
                    subscriptionResource.removeProperty(key);
                }
                properties = subscription.getProperties();
                for (String key : properties.keySet()) {
                    subscriptionResource.setProperty(key, properties.get(key));
                }
            } else {
                throw new EventBrokerException("Can not find the resouce to the subscription with id " + subscription.getId());
            }
            userRegistry.put(subscriptionPath, subscriptionResource);
        }
        catch (RegistryException e) {
            throw new EventBrokerException("Can not access the registry ", e);
        }
    }

    @Override
    public void unSubscribe(String subscriptionID) throws EventBrokerException {
        try {
            UserRegistry userRegistry = this.registryService.getGovernanceSystemRegistry(EventBrokerHolder.getInstance().getTenantId());
            String fullPath = this.indexStoragePath;
            if (userRegistry.resourceExists(fullPath)) {
                Resource topicIndexResource = userRegistry.get(fullPath);
                String topicName = topicIndexResource.getProperty(subscriptionID);
                if (topicName != null) {
                    userRegistry.delete(this.getResourcePath(subscriptionID, topicName));
                }
                topicIndexResource.removeProperty(subscriptionID);
                userRegistry.put(fullPath, topicIndexResource);
            }
        }
        catch (RegistryException e) {
            throw new EventBrokerException("Can not access the registry ", e);
        }
    }

    @Override
    public String getTopicStoragePath() throws EventBrokerException {
        return this.topicStoragePath;
    }
}

