/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.ws.internal.builders;

import java.util.Calendar;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.databinding.types.Duration;
import org.apache.axis2.databinding.utils.ConverterUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.event.core.subscription.Subscription;
import org.wso2.carbon.event.ws.internal.builders.CommandBuilderConstants;
import org.wso2.carbon.event.ws.internal.builders.SubscribeCommandBuilder;
import org.wso2.carbon.event.ws.internal.builders.exceptions.BuilderException;
import org.wso2.carbon.event.ws.internal.builders.exceptions.InvalidExpirationTimeException;
import org.wso2.carbon.event.ws.internal.builders.exceptions.InvalidMessageException;

public class RenewCommandBuilder
extends CommandBuilderConstants {
    private static final Log log = LogFactory.getLog(SubscribeCommandBuilder.class);
    private SOAPFactory factory;

    public RenewCommandBuilder(MessageContext messageCtx) {
        this.factory = (SOAPFactory)messageCtx.getEnvelope().getOMFactory();
    }

    public Subscription toSubscription(SOAPEnvelope envelope) throws InvalidMessageException, InvalidExpirationTimeException {
        if (envelope == null) {
            log.error((Object)"No SOAP envelope was provided.");
            throw new BuilderException("No SOAP envelope was provided.");
        }
        Subscription subscription = new Subscription();
        OMElement elem = null;
        if (envelope.getHeader() != null) {
            elem = envelope.getHeader().getFirstChildWithName(IDENTIFIER);
        }
        if (elem == null) {
            log.error((Object)"Subscription Identifier is required as a header of the subscription message.");
            throw new InvalidMessageException("Subscription Identifier is required as a header of the subscription message.");
        }
        String id = elem.getText().trim();
        subscription.setId(id);
        OMElement renewElem = envelope.getBody().getFirstChildWithName(RENEW);
        if (renewElem != null) {
            OMElement expiryElem = renewElem.getFirstChildWithName(EXPIRES);
            if (expiryElem != null) {
                Calendar calendarExpires;
                try {
                    String expiryText = expiryElem.getText().trim();
                    if (expiryText.startsWith("P")) {
                        calendarExpires = Calendar.getInstance();
                        Duration duration = ConverterUtil.convertToDuration((String)expiryText);
                        calendarExpires.add(1, duration.getYears());
                        calendarExpires.add(2, duration.getMonths());
                        calendarExpires.add(5, duration.getDays());
                        calendarExpires.add(11, duration.getHours());
                        calendarExpires.add(12, duration.getMinutes());
                        calendarExpires.add(13, (int)duration.getSeconds());
                    } else {
                        calendarExpires = ConverterUtil.convertToDateTime((String)expiryText);
                    }
                }
                catch (Exception e) {
                    log.error((Object)"Error converting the expiration date", (Throwable)e);
                    throw new InvalidExpirationTimeException("Error converting the expiration date", e);
                }
                Calendar calendarNow = Calendar.getInstance();
                if (!calendarNow.before(calendarExpires)) {
                    log.error((Object)"The expiration time has passed");
                    throw new InvalidExpirationTimeException("The expiration time has passed");
                }
                subscription.setExpires(calendarExpires);
                subscription.setExpires(calendarExpires);
            } else {
                log.error((Object)"The expiration time was not given");
                throw new InvalidExpirationTimeException("The expiration time was not given");
            }
        }
        return subscription;
    }

    public SOAPEnvelope fromSubscription(Subscription subscription) {
        SOAPEnvelope message = this.factory.getDefaultEnvelope();
        OMNamespace eventingNamespace = this.factory.createOMNamespace("http://schemas.xmlsoap.org/ws/2004/08/eventing", "wse");
        OMElement renewResponseElement = this.factory.createOMElement("RenewResponse", eventingNamespace);
        OMElement expiresElement = this.factory.createOMElement("Expires", eventingNamespace);
        this.factory.createOMText((OMContainer)expiresElement, ConverterUtil.convertToString((Calendar)subscription.getExpires()));
        renewResponseElement.addChild((OMNode)expiresElement);
        message.getBody().addChild((OMNode)renewResponseElement);
        return message;
    }
}

