/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.core.internal.util;

import java.util.Date;
import java.util.Enumeration;
import java.util.Properties;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.databinding.utils.ConverterUtil;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.event.core.exception.EventBrokerConfigurationException;
import org.wso2.carbon.event.core.exception.EventBrokerException;
import org.wso2.carbon.event.core.internal.util.EventBrokerHolder;
import org.wso2.carbon.event.core.subscription.Subscription;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.user.api.UserStoreException;

public class JavaUtil {
    public static Object getObject(OMElement omElement) throws EventBrokerConfigurationException {
        String className = omElement.getAttributeValue(new QName(null, "class"));
        try {
            Class<?> factoryClass = Class.forName(className);
            return factoryClass.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new EventBrokerConfigurationException("Class " + className + " not found ", e);
        }
        catch (IllegalAccessException e) {
            throw new EventBrokerConfigurationException("Class not be accesed ", e);
        }
        catch (InstantiationException e) {
            throw new EventBrokerConfigurationException("Class not be instantiated ", e);
        }
    }

    public static String getValue(OMElement omElement, String localPart) {
        OMElement childElement = omElement.getFirstChildWithName(new QName(omElement.getNamespace().getNamespaceURI(), localPart));
        return childElement.getText();
    }

    public static Subscription getSubscription(Resource subscriptionResource) {
        Subscription subscription = new Subscription();
        Properties properties = subscriptionResource.getProperties();
        if (properties != null && !properties.isEmpty()) {
            Enumeration<?> enumeration = properties.propertyNames();
            while (enumeration.hasMoreElements()) {
                String propertyName = (String)enumeration.nextElement();
                if ("subscriptionURL".equals(propertyName)) {
                    subscription.setEventSinkURL(subscriptionResource.getProperty("subscriptionURL"));
                    continue;
                }
                if ("eventDispatcherName".equals(propertyName)) {
                    subscription.setEventDispatcherName(subscriptionResource.getProperty("eventDispatcherName"));
                    continue;
                }
                if ("expires".equals(propertyName)) {
                    subscription.setExpires(ConverterUtil.convertToDateTime((String)subscriptionResource.getProperty("expires")));
                    continue;
                }
                if ("owner".equals(propertyName)) {
                    subscription.setOwner(subscriptionResource.getProperty("owner"));
                    continue;
                }
                if ("topicName".equals(propertyName)) {
                    subscription.setTopicName(subscriptionResource.getProperty("topicName"));
                    continue;
                }
                if ("createdTime".equals(propertyName)) {
                    subscription.setCreatedTime(new Date(Long.parseLong(subscriptionResource.getProperty("createdTime"))));
                    continue;
                }
                if ("mode".equals(propertyName)) {
                    subscription.setMode(subscriptionResource.getProperty("mode"));
                    continue;
                }
                subscription.addProperty(propertyName, subscriptionResource.getProperty(propertyName));
            }
        }
        return subscription;
    }

    public static String getSubscriptionMode(String topicName) {
        int length = topicName.length();
        String modeSubstring = topicName.substring(length - 2);
        if (modeSubstring.equals("/*")) {
            return "mode_1";
        }
        if (modeSubstring.equals("/#")) {
            return "mode_2";
        }
        return "mode_0";
    }

    public static boolean isAdmin(String username) throws EventBrokerException {
        boolean isAdmin = false;
        try {
            String[] userRoles = EventBrokerHolder.getInstance().getRealmService().getTenantUserRealm(CarbonContext.getCurrentContext().getTenantId()).getUserStoreManager().getRoleListOfUser(username);
            String adminRole = EventBrokerHolder.getInstance().getRealmService().getBootstrapRealmConfiguration().getAdminRoleName();
            for (String userRole : userRoles) {
                if (!adminRole.equals(userRole)) continue;
                isAdmin = true;
                break;
            }
        }
        catch (UserStoreException e) {
            throw new EventBrokerException("Failed to get list of user roles", e);
        }
        return isAdmin;
    }

    public static String getResourcePath(String topicName, String topicStoragePath) {
        String resourcePath = topicStoragePath;
        if (!(topicName = topicName.replaceAll("\\.", "/")).startsWith("/")) {
            resourcePath = resourcePath + "/";
        }
        if (topicName.indexOf("*") > -1) {
            topicName = topicName.substring(0, topicName.indexOf("*"));
        } else if (topicName.indexOf("#") > -1) {
            topicName = topicName.substring(0, topicName.indexOf("#"));
        }
        resourcePath = resourcePath + topicName;
        return resourcePath;
    }
}

