/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.core.internal.builder;

import java.util.ArrayList;
import java.util.List;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.core.multitenancy.SuperTenantCarbonContext;
import org.wso2.carbon.event.core.EventBroker;
import org.wso2.carbon.utils.AbstractAxis2ConfigurationContextObserver;

public class EventAxis2ConfigurationContextObserver
extends AbstractAxis2ConfigurationContextObserver {
    private static Log log = LogFactory.getLog(EventAxis2ConfigurationContextObserver.class);
    private EventBroker eventBroker;
    private List<String> loadedTenants = new ArrayList<String>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createdConfigurationContext(ConfigurationContext configurationContext) {
        String tenantDomain = SuperTenantCarbonContext.getCurrentContext((ConfigurationContext)configurationContext).getTenantDomain();
        int tenantID = SuperTenantCarbonContext.getCurrentContext((ConfigurationContext)configurationContext).getTenantId();
        try {
            SuperTenantCarbonContext.startTenantFlow();
            SuperTenantCarbonContext.getCurrentContext().setTenantId(tenantID);
            SuperTenantCarbonContext.getCurrentContext().getTenantDomain(true);
            if (!this.loadedTenants.contains(tenantDomain.trim())) {
                this.eventBroker.initializeTenant();
                this.loadedTenants.add(tenantDomain.trim());
            }
        }
        catch (Exception e) {
            log.error((Object)"Error in setting tenant information", (Throwable)e);
        }
        finally {
            SuperTenantCarbonContext.endTenantFlow();
        }
    }

    public void setEventBroker(EventBroker eventBroker) {
        this.eventBroker = eventBroker;
    }
}

