/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mediator.aggregate;

import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.synapse.config.xml.SynapseXPathFactory;
import org.apache.synapse.config.xml.SynapseXPathSerializer;
import org.apache.synapse.config.xml.ValueFactory;
import org.apache.synapse.config.xml.ValueSerializer;
import org.apache.synapse.mediators.Value;
import org.apache.synapse.util.xpath.SynapseXPath;
import org.jaxen.JaxenException;
import org.wso2.carbon.mediator.drop.DropMediator;
import org.wso2.carbon.mediator.service.MediatorException;
import org.wso2.carbon.mediator.service.ui.AbstractListMediator;
import org.wso2.carbon.mediator.service.ui.ListMediator;
import org.wso2.carbon.mediator.service.ui.Mediator;

public class AggregateMediator
extends AbstractListMediator {
    protected static final QName CORELATE_ON_Q = new QName("http://ws.apache.org/ns/synapse", "correlateOn");
    protected static final QName COMPLETE_CONDITION_Q = new QName("http://ws.apache.org/ns/synapse", "completeCondition");
    protected static final QName MESSAGE_COUNT_Q = new QName("http://ws.apache.org/ns/synapse", "messageCount");
    protected static final QName ON_COMPLETE_Q = new QName("http://ws.apache.org/ns/synapse", "onComplete");
    private static final QName EXPRESSION_Q = new QName("", "expression");
    private static final QName TIMEOUT_Q = new QName("", "timeout");
    private static final QName MIN_Q = new QName("", "min");
    private static final QName MAX_Q = new QName("", "max");
    private static final QName SEQUENCE_Q = new QName("", "sequence");
    private static final QName ID_Q = new QName("id");
    private long completionTimeoutSec = 0L;
    private Value minMessagesToComplete;
    private Value maxMessagesToComplete;
    private SynapseXPath correlateExpression = null;
    private SynapseXPath aggregationExpression = null;
    private String onCompleteSequenceRef = null;
    private String id;

    public long getCompletionTimeoutSec() {
        return this.completionTimeoutSec;
    }

    public Value getMinMessagesToComplete() {
        return this.minMessagesToComplete;
    }

    public void setMinMessagesToComplete(Value minMessagesToComplete) {
        this.minMessagesToComplete = minMessagesToComplete;
    }

    public Value getMaxMessagesToComplete() {
        return this.maxMessagesToComplete;
    }

    public void setMaxMessagesToComplete(Value maxMessagesToComplete) {
        this.maxMessagesToComplete = maxMessagesToComplete;
    }

    public void setCompletionTimeoutSec(long completionTimeoutSec) {
        this.completionTimeoutSec = completionTimeoutSec;
    }

    public SynapseXPath getCorrelateExpression() {
        return this.correlateExpression;
    }

    public void setCorrelateExpression(SynapseXPath correlateExpression) {
        this.correlateExpression = correlateExpression;
    }

    public SynapseXPath getAggregationExpression() {
        return this.aggregationExpression;
    }

    public void setAggregationExpression(SynapseXPath aggregationExpression) {
        this.aggregationExpression = aggregationExpression;
    }

    public String getOnCompleteSequenceRef() {
        return this.onCompleteSequenceRef;
    }

    public void setOnCompleteSequenceRef(String onCompleteSequenceRef) {
        this.onCompleteSequenceRef = onCompleteSequenceRef;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getTagLocalName() {
        return "aggregate";
    }

    public OMElement serialize(OMElement parent) {
        OMElement aggregator = fac.createOMElement("aggregate", synNS);
        AggregateMediator.saveTracingState((OMElement)aggregator, (Mediator)this);
        if (this.correlateExpression != null) {
            OMElement corelateOn = fac.createOMElement("correlateOn", synNS);
            SynapseXPathSerializer.serializeXPath((SynapseXPath)this.correlateExpression, (OMElement)corelateOn, (String)"expression");
            aggregator.addChild((OMNode)corelateOn);
        }
        OMElement completeCond = fac.createOMElement("completeCondition", synNS);
        if (this.completionTimeoutSec != 0L) {
            completeCond.addAttribute("timeout", Long.toString(this.completionTimeoutSec), nullNS);
        }
        OMElement messageCount = fac.createOMElement("messageCount", synNS);
        if (this.minMessagesToComplete != null) {
            OMElement min = fac.createOMElement("min", synNS);
            new ValueSerializer().serializeValue(this.minMessagesToComplete, "min", messageCount);
        }
        if (this.maxMessagesToComplete != null) {
            OMElement max = fac.createOMElement("min", synNS);
            new ValueSerializer().serializeValue(this.maxMessagesToComplete, "max", messageCount);
        }
        completeCond.addChild((OMNode)messageCount);
        aggregator.addChild((OMNode)completeCond);
        OMElement onCompleteElem = fac.createOMElement("onComplete", synNS);
        if (this.aggregationExpression != null) {
            SynapseXPathSerializer.serializeXPath((SynapseXPath)this.aggregationExpression, (OMElement)onCompleteElem, (String)"expression");
        }
        if (this.onCompleteSequenceRef != null) {
            onCompleteElem.addAttribute("sequence", this.onCompleteSequenceRef, nullNS);
        } else if (this.getList().size() > 0) {
            this.serializeChildren(onCompleteElem, this.getList());
        }
        aggregator.addChild((OMNode)onCompleteElem);
        if (this.id != null) {
            aggregator.addAttribute("id", this.id, nullNS);
        }
        if (parent != null) {
            parent.addChild((OMNode)aggregator);
        }
        return aggregator;
    }

    public void build(OMElement elem) {
        OMElement onComplete;
        OMElement completeCond;
        OMAttribute corelateExpr;
        OMElement corelateOn = elem.getFirstChildWithName(CORELATE_ON_Q);
        OMAttribute idAttr = elem.getAttribute(ID_Q);
        ValueFactory valueFactory = new ValueFactory();
        if (idAttr != null) {
            this.id = idAttr.getAttributeValue();
        }
        if (corelateOn != null && (corelateExpr = corelateOn.getAttribute(EXPRESSION_Q)) != null) {
            try {
                this.correlateExpression = SynapseXPathFactory.getSynapseXPath((OMElement)corelateOn, (QName)EXPRESSION_Q);
            }
            catch (JaxenException e) {
                throw new MediatorException("Unable to load the corelate XPATH expression");
            }
        }
        if ((completeCond = elem.getFirstChildWithName(COMPLETE_CONDITION_Q)) != null) {
            OMElement messageCount;
            OMAttribute completeTimeout = completeCond.getAttribute(TIMEOUT_Q);
            if (completeTimeout != null) {
                this.completionTimeoutSec = Long.parseLong(completeTimeout.getAttributeValue());
            }
            if ((messageCount = completeCond.getFirstChildWithName(MESSAGE_COUNT_Q)) != null) {
                OMAttribute maxExpr;
                OMAttribute minExpr = messageCount.getAttribute(MIN_Q);
                if (minExpr != null) {
                    try {
                        Value min;
                        this.minMessagesToComplete = min = valueFactory.createValue("min", messageCount);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        throw new MediatorException("Unable to load the corelate XPATH expression");
                    }
                }
                if ((maxExpr = messageCount.getAttribute(MAX_Q)) != null) {
                    try {
                        Value max;
                        this.maxMessagesToComplete = max = valueFactory.createValue("max", messageCount);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        throw new MediatorException("Unable to load the corelate XPATH expression");
                    }
                }
            }
        }
        if ((onComplete = elem.getFirstChildWithName(ON_COMPLETE_Q)) != null) {
            OMAttribute onCompleteSequence;
            OMAttribute aggregateExpr = onComplete.getAttribute(EXPRESSION_Q);
            if (aggregateExpr != null) {
                try {
                    this.aggregationExpression = SynapseXPathFactory.getSynapseXPath((OMElement)onComplete, (QName)EXPRESSION_Q);
                }
                catch (JaxenException e) {
                    throw new MediatorException("Unable to load the aggregating XPATH");
                }
            }
            if ((onCompleteSequence = onComplete.getAttribute(SEQUENCE_Q)) != null) {
                this.onCompleteSequenceRef = onCompleteSequence.getAttributeValue();
            } else if (onComplete.getFirstElement() != null) {
                this.addChildren(onComplete, (ListMediator)this);
            } else {
                this.addChild((Mediator)new DropMediator());
            }
        }
    }
}

