/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mediator.calltemplate.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNamespace;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.SynapseException;
import org.apache.synapse.util.xpath.SynapseXPath;
import org.jaxen.JaxenException;

public class Value {
    private static final Log log = LogFactory.getLog(org.apache.synapse.mediators.Value.class);
    private String name = null;
    private String keyValue = null;
    private SynapseXPath expression = null;
    private List<OMNamespace> namespaceList = new ArrayList<OMNamespace>();

    public Value(String staticKey) {
        this.keyValue = staticKey;
    }

    public Value(SynapseXPath expression) {
        this.expression = expression;
    }

    public String getKeyValue() {
        return this.keyValue;
    }

    public SynapseXPath getExpression() {
        if (this.expression == null && this.keyValue != null && this.hasExprTypeKey()) {
            try {
                this.expression = new SynapseXPath(this.keyValue.substring(1, this.keyValue.length() - 1));
                for (OMNamespace aNamespaceList : this.namespaceList) {
                    this.expression.addNamespace(aNamespaceList);
                }
            }
            catch (JaxenException e) {
                this.expression = null;
                this.handleException("Can not evaluate escaped expression..");
            }
        }
        return this.expression;
    }

    private void handleException(String msg) {
        log.error((Object)msg);
        throw new SynapseException(msg);
    }

    public boolean hasExprTypeKey() {
        return this.keyValue != null && this.keyValue.startsWith("{") && this.keyValue.endsWith("}");
    }

    public void setNamespaces(OMElement elem) {
        Iterator namespaces = elem.getAllDeclaredNamespaces();
        while (namespaces.hasNext()) {
            OMNamespace ns = (OMNamespace)namespaces.next();
            this.namespaceList.add(ns);
        }
    }

    public void addNamespace(OMNamespace ns) {
        if (ns != null) {
            this.namespaceList.add(ns);
        }
    }

    public String toString() {
        return "Value {name ='" + this.name + '\'' + (this.keyValue != null ? ", keyValue ='" + this.keyValue + '\'' : "") + (this.expression != null ? ", expression =" + this.expression : "") + '}';
    }
}

