/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mediator.calltemplate;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.synapse.SynapseException;
import org.wso2.carbon.mediator.calltemplate.util.Value;
import org.wso2.carbon.mediator.calltemplate.util.ValueFactory;
import org.wso2.carbon.mediator.calltemplate.util.ValueSerializer;
import org.wso2.carbon.mediator.service.ui.AbstractMediator;
import org.wso2.carbon.mediator.service.ui.Mediator;

public class CallTemplateMediator
extends AbstractMediator {
    private String targetTemplate;
    private Map<String, Value> pName2ExpressionMap = new HashMap<String, Value>();
    public static final QName WITH_PARAM_Q = new QName("http://ws.apache.org/ns/synapse", "with-param");
    public static final String INVOKE_N = "call-template";

    public String getTargetTemplate() {
        return this.targetTemplate;
    }

    public void setTargetTemplate(String targetTemplate) {
        this.targetTemplate = targetTemplate;
    }

    public Map<String, Value> getpName2ExpressionMap() {
        return this.pName2ExpressionMap;
    }

    public void addExpressionForParamName(String pName, Value expr) {
        this.pName2ExpressionMap.put(pName, expr);
    }

    public String getTagLocalName() {
        return INVOKE_N;
    }

    public OMElement serialize(OMElement parent) {
        OMElement callTemplateElem = fac.createOMElement(INVOKE_N, synNS);
        if (this.getTargetTemplate() != null) {
            callTemplateElem.addAttribute(fac.createOMAttribute("target", nullNS, this.getTargetTemplate()));
            this.serializeParams(callTemplateElem, this);
            CallTemplateMediator.saveTracingState((OMElement)callTemplateElem, (Mediator)this);
        }
        if (parent != null) {
            parent.addChild((OMNode)callTemplateElem);
        }
        return callTemplateElem;
    }

    private void serializeParams(OMElement invokeElem, CallTemplateMediator mediator) {
        Map<String, Value> paramsMap = mediator.getpName2ExpressionMap();
        for (String paramName : paramsMap.keySet()) {
            if ("".equals(paramName)) continue;
            OMElement paramEl = fac.createOMElement(WITH_PARAM_Q.getLocalPart(), synNS);
            paramEl.addAttribute(fac.createOMAttribute("name", nullNS, paramName));
            Value value = paramsMap.get(paramName);
            new ValueSerializer().serializeValue(value, "value", paramEl);
            invokeElem.addChild((OMNode)paramEl);
        }
    }

    public void build(OMElement elem) {
        this.processAuditStatus((Mediator)this, elem);
        OMAttribute targetTemplateAttr = elem.getAttribute(ATT_TARGET);
        if (targetTemplateAttr == null) {
            String msg = "CAll template mediator should have a target template specified.";
            throw new SynapseException(msg);
        }
        this.setTargetTemplate(targetTemplateAttr.getAttributeValue());
        this.buildParameters(elem);
    }

    private void buildParameters(OMElement elem) {
        Iterator subElements = elem.getChildElements();
        while (subElements.hasNext()) {
            OMElement child = (OMElement)subElements.next();
            if (!child.getQName().equals(WITH_PARAM_Q)) continue;
            OMAttribute paramNameAttr = child.getAttribute(ATT_NAME);
            Value paramValue = new ValueFactory().createValue("value", child);
            if (paramNameAttr == null) continue;
            this.addExpressionForParamName(paramNameAttr.getAttributeValue(), paramValue);
        }
    }
}

