/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.sequences.common.factory;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import org.apache.synapse.mediators.base.SequenceMediator;
import org.wso2.carbon.sequences.common.to.SequenceInfo;

public class SequenceInfoFactory {
    public static SequenceInfo createSequenceInfo(SequenceMediator sequenceMediator) {
        SequenceInfo sequenceInfo = new SequenceInfo();
        sequenceInfo.setName(sequenceMediator.getName());
        sequenceInfo.setDescription(sequenceMediator.getDescription());
        if (sequenceMediator.isStatisticsEnable()) {
            sequenceInfo.setEnableStatistics(true);
        } else {
            sequenceInfo.setEnableStatistics(false);
        }
        if (sequenceMediator.getTraceState() == 1) {
            sequenceInfo.setEnableTracing(true);
        } else {
            sequenceInfo.setEnableTracing(false);
        }
        return sequenceInfo;
    }

    public static SequenceInfo[] getSortedSequenceInfoArray(Collection<SequenceMediator> sequenceMediators) {
        ArrayList<SequenceInfo> sequenceInfoList = new ArrayList<SequenceInfo>();
        for (SequenceMediator sequenceMediator : sequenceMediators) {
            sequenceInfoList.add(SequenceInfoFactory.createSequenceInfo(sequenceMediator));
        }
        Collections.sort(sequenceInfoList, new Comparator<SequenceInfo>(){

            @Override
            public int compare(SequenceInfo info1, SequenceInfo info2) {
                return info1.getName().compareToIgnoreCase(info2.getName());
            }
        });
        return sequenceInfoList.toArray(new SequenceInfo[sequenceInfoList.size()]);
    }
}

