/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mediator.target.ui.client;

import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.endpoints.Endpoint;
import org.apache.synapse.endpoints.IndirectEndpoint;
import org.wso2.carbon.proxyadmin.stub.ProxyServiceAdminStub;

public class ProxyAdminClient {
    private static final Log log = LogFactory.getLog(ProxyAdminClient.class);
    private static final String BUNDLE = "org.wso2.carbon.mediator.target.ui.i18n.Resources";
    private ResourceBundle bundle;
    public ProxyServiceAdminStub stub;

    public ProxyAdminClient(ConfigurationContext configCtx, String backendServerURL, String cookie, Locale locale) throws AxisFault {
        this.bundle = ResourceBundle.getBundle(BUNDLE, locale);
        String serviceURL = backendServerURL + "ProxyServiceAdmin";
        this.stub = new ProxyServiceAdminStub(configCtx, serviceURL);
        ServiceClient client = this.stub._getServiceClient();
        Options options = client.getOptions();
        options.setManageSession(true);
        options.setProperty("Cookie", (Object)cookie);
    }

    public String[] getAvailableEndpoints() throws AxisFault {
        try {
            return this.stub.getAvailableEndpoints();
        }
        catch (Exception e) {
            this.handleException(this.bundle.getString("unable.to.get.declared.endpoints"), e);
            return null;
        }
    }

    private void handleException(String msg, Exception e) throws AxisFault {
        log.error((Object)msg, (Throwable)e);
        throw new AxisFault(msg, (Throwable)e);
    }

    public Endpoint getEndpoint(String name) {
        IndirectEndpoint iep = new IndirectEndpoint();
        iep.setKey(name);
        return iep;
    }
}

