/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mediator.service.ui;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.axiom.om.OMElement;
import org.wso2.carbon.mediator.service.MediatorException;
import org.wso2.carbon.mediator.service.MediatorService;
import org.wso2.carbon.mediator.service.MediatorStore;
import org.wso2.carbon.mediator.service.ui.AbstractMediator;
import org.wso2.carbon.mediator.service.ui.ListMediator;
import org.wso2.carbon.mediator.service.ui.Mediator;

public abstract class AbstractListMediator
extends AbstractMediator
implements ListMediator {
    protected List<Mediator> mediators = new ArrayList<Mediator>();

    @Override
    public List<Mediator> getList() {
        return this.mediators;
    }

    @Override
    public Mediator getChild(int pos) {
        return this.mediators.get(pos);
    }

    @Override
    public Mediator removeChild(int pos) {
        return this.mediators.remove(pos);
    }

    @Override
    public boolean removeChild(Mediator mediator) {
        return this.mediators.remove(mediator);
    }

    @Override
    public void addChild(Mediator mediator) {
        this.mediators.add(mediator);
    }

    protected void serializeChildren(OMElement parent, List<Mediator> list) {
        for (Mediator child : list) {
            child.serialize(parent);
        }
    }

    protected void addChildren(OMElement el, ListMediator m) {
        Iterator it = el.getChildElements();
        while (it.hasNext()) {
            OMElement child = (OMElement)it.next();
            MediatorService mediatorService = MediatorStore.getInstance().getMediatorService(child);
            if (mediatorService == null) continue;
            Mediator med = mediatorService.getMediator();
            if (med != null) {
                med.build(child);
                m.addChild(med);
                continue;
            }
            String msg = "Unknown mediator : " + child.getLocalName();
            throw new MediatorException(msg);
        }
    }
}

