/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mediator.service;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.axiom.om.OMElement;
import org.wso2.carbon.mediator.service.MediatorService;
import org.wso2.carbon.mediator.service.builtin.SequenceMediatorService;
import org.wso2.carbon.mediator.service.builtin.UILessMediatorService;

public class MediatorStore {
    private static MediatorStore instance = null;
    private Map<String, MediatorService> store = new HashMap<String, MediatorService>();

    private MediatorStore() {
    }

    public static synchronized MediatorStore getInstance() {
        if (instance == null) {
            SequenceMediatorService service = new SequenceMediatorService();
            instance = new MediatorStore();
            instance.registerMediator(service.getTagLocalName(), service);
        }
        return instance;
    }

    public void registerMediator(String mediatorName, MediatorService mediatorService) {
        this.store.put(mediatorName, mediatorService);
    }

    public void unRegisterMediator(String mediatorName) {
        this.store.remove(mediatorName);
    }

    public MediatorService getMediatorService(String mediatorName) {
        MediatorService service = this.store.get(mediatorName);
        if (service == null) {
            UILessMediatorService defService = new UILessMediatorService();
            defService.setLocalName(mediatorName);
            return defService;
        }
        return service;
    }

    public Collection<MediatorService> getRegisteredMediators() {
        return this.store.values();
    }

    public HashMap<String, HashMap<String, String>> getMediatorMenuItems() {
        HashMap<String, HashMap<String, String>> parentMap = new HashMap<String, HashMap<String, String>>();
        for (MediatorService mediatorService : this.store.values()) {
            HashMap<Object, Object> menuMap;
            String group = mediatorService.getGroupName();
            if (group == null || "uiless".equals(group.toLowerCase())) continue;
            if (parentMap.containsKey(group)) {
                menuMap = parentMap.get(group);
            } else {
                menuMap = new HashMap();
                parentMap.put(group, menuMap);
            }
            menuMap.put(mediatorService.getTagLocalName(), mediatorService.getDisplayName());
        }
        return parentMap;
    }

    public MediatorService getMediatorService(OMElement element) {
        return this.getMediatorService(element.getLocalName());
    }
}

