/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.message.store.ui.utils;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.synapse.config.xml.MessageStoreFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageStoreData {
    private String name;
    private String clazz;
    private String sequence;
    private Map<String, String> params = new HashMap<String, String>();

    public MessageStoreData(String xml) throws XMLStreamException {
        this.populate(xml);
    }

    public String getName() {
        return this.name;
    }

    public String getSequence() {
        return this.sequence;
    }

    public Map<String, String> getParams() {
        return this.params;
    }

    public String getClazz() {
        return this.clazz;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setClazz(String provider) {
        this.clazz = provider;
    }

    private void populate(String xml) throws XMLStreamException {
        ByteArrayInputStream in = new ByteArrayInputStream(xml.getBytes());
        OMElement elem = new StAXOMBuilder((InputStream)in).getDocumentElement();
        OMAttribute attElem = elem.getAttribute(MessageStoreFactory.CLASS_Q);
        if (attElem != null) {
            this.clazz = attElem.getAttributeValue();
        }
        if ((attElem = elem.getAttribute(MessageStoreFactory.NAME_Q)) != null) {
            this.name = attElem.getAttributeValue();
        }
        if ((attElem = elem.getAttribute(MessageStoreFactory.SEQUENCE_Q)) != null) {
            this.sequence = attElem.getAttributeValue();
        }
        Iterator it = elem.getChildrenWithName(MessageStoreFactory.PARAMETER_Q);
        while (it.hasNext()) {
            OMElement paramElem = (OMElement)it.next();
            OMAttribute nameAtt = paramElem.getAttribute(MessageStoreFactory.NAME_Q);
            assert (nameAtt != null);
            String name = nameAtt.getAttributeValue();
            String value = paramElem.getText();
            this.params.put(name, value);
        }
    }

    public String getString() {
        StringBuffer storeString = new StringBuffer();
        storeString.append("name: " + this.name + "\n");
        storeString.append("clazz: " + this.clazz + "\n");
        storeString.append("sequence: " + this.sequence + "\n");
        storeString.append("params: " + this.params + "\n");
        return storeString.toString();
    }
}

