/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.message.store.ui;

import java.util.ArrayList;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.message.store.stub.MessageInfo;
import org.wso2.carbon.message.store.stub.MessageStoreAdminServiceStub;
import org.wso2.carbon.message.store.ui.utils.MessageStoreData;

public class MessageStoreAdminServiceClient {
    private MessageStoreAdminServiceStub stub;
    private static final String adminServiceName = "MessageStoreAdminService";
    private static Log log = LogFactory.getLog(MessageStoreAdminServiceClient.class);
    public static int MESSAGE_STORES_PER_PAGE = 10;

    public MessageStoreAdminServiceClient(String cookie, String backendServerUrl, ConfigurationContext configurationContext) throws AxisFault {
        String serviceURL = backendServerUrl + adminServiceName;
        this.stub = new MessageStoreAdminServiceStub(configurationContext, serviceURL);
        ServiceClient client = this.stub._getServiceClient();
        Options option = client.getOptions();
        option.setManageSession(true);
        option.setProperty("Cookie", (Object)cookie);
    }

    public void addMessageStore(String xml) throws Exception {
        try {
            if (xml != null) {
                this.stub.addMessageStore(xml);
            } else {
                this.handleException("Error Can't add message store. Error in the configuration " + xml);
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public void modifyMessageStore(String xml) throws Exception {
        try {
            if (xml != null) {
                this.stub.modifyMessageStore(xml);
            } else {
                this.handleException("Error Can't change message store. Error in the configuration " + xml);
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public void deleteMessageStore(String name) throws Exception {
        try {
            if (name != null) {
                this.stub.deleteMessageStore(name);
            } else {
                this.handleException("Error Can't delete Message Store " + name);
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public String[] getMessageStoreNames() throws Exception {
        String[] messageStoreNames = null;
        try {
            messageStoreNames = this.stub.getMessageStoreNames();
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return messageStoreNames;
    }

    public String[] getPaginatedMessageStoreNames(int pageNumber) throws Exception {
        int numberOfPages = 0;
        String[] messageStoreNames = this.getMessageStoreNames();
        if (messageStoreNames != null) {
            numberOfPages = (int)Math.ceil((double)messageStoreNames.length / (double)MESSAGE_STORES_PER_PAGE);
        }
        if (pageNumber == 0) {
            numberOfPages = 1;
        }
        if (pageNumber > numberOfPages - 1) {
            pageNumber = numberOfPages - 1;
        }
        int startIndex = pageNumber * MESSAGE_STORES_PER_PAGE;
        int endIndex = (pageNumber + 1) * MESSAGE_STORES_PER_PAGE;
        if (messageStoreNames == null) {
            return null;
        }
        ArrayList<String> nameList = new ArrayList<String>();
        for (int i = startIndex; i < endIndex && i < messageStoreNames.length; ++i) {
            nameList.add(messageStoreNames[i]);
        }
        return nameList.toArray(new String[nameList.size()]);
    }

    public MessageInfo[] getPaginatedMessages(String name, int pageNumber) throws Exception {
        MessageInfo[] messageInfos = null;
        try {
            if (name != null) {
                messageInfos = this.stub.getPaginatedMessages(name, pageNumber);
            } else {
                this.handleException("Error Can't get messages form Message Store " + name);
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return messageInfos;
    }

    public int getSize(String name) throws Exception {
        int size = 0;
        try {
            if (name != null) {
                size = this.stub.getSize(name);
            } else {
                this.handleException("Error Can't get Message Store size for Message store" + name);
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return size;
    }

    public String getEnvelope(String name, String messageId) throws Exception {
        String envelope = null;
        try {
            if (name != null) {
                envelope = this.stub.getEnvelope(name, messageId);
            } else {
                this.handleException("Error Can't access Message store" + name);
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return envelope;
    }

    public MessageStoreData getMessageStore(String name) throws Exception {
        MessageStoreData data = null;
        try {
            if (name != null) {
                String xml = this.stub.getMessageStore(name);
                assert (xml != null);
                data = new MessageStoreData(xml);
            } else {
                this.handleException("Error Can't access Message store" + name);
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return data;
    }

    public void deleteAllMessages(String name) throws Exception {
        try {
            if (name != null) {
                this.stub.deleteAllMessages(name);
            } else {
                this.handleException("Error Can't delete all messages from Message store" + name);
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public void deleteMessage(String name, String messageId) throws Exception {
        try {
            if (name != null) {
                this.stub.deleteMessage(name, messageId);
            } else {
                this.handleException("Error accessing Message store" + name);
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public void deleteFirstMessages(String name) throws Exception {
        try {
            if (name != null) {
                this.stub.deleteFirstMessages(name);
            } else {
                this.handleException("Error accessing Message store" + name);
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public String getClassName(String name) throws Exception {
        String className = null;
        try {
            if (name != null) {
                className = this.stub.getClassName(name);
            } else {
                this.handleException("Error accessing Message store" + name);
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return className;
    }

    private void handleException(Exception e) throws Exception {
        String message = "Error Executing MessageStoreAdminServiceClient" + e.getMessage();
        log.error((Object)message, (Throwable)e);
        throw e;
    }

    private void handleException(String message) throws Exception {
        log.error((Object)message);
        throw new Exception(message);
    }
}

