/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mediator.switchm;

import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.synapse.config.xml.SynapseXPathFactory;
import org.apache.synapse.config.xml.SynapseXPathSerializer;
import org.apache.synapse.util.xpath.SynapseXPath;
import org.jaxen.JaxenException;
import org.wso2.carbon.mediator.service.MediatorException;
import org.wso2.carbon.mediator.service.ui.AbstractListMediator;
import org.wso2.carbon.mediator.service.ui.ListMediator;
import org.wso2.carbon.mediator.service.ui.Mediator;

public class SwitchMediator
extends AbstractListMediator {
    private static final QName CASE_Q = new QName("http://ws.apache.org/ns/synapse", "case");
    private static final QName DEFAULT_Q = new QName("http://ws.apache.org/ns/synapse", "default");
    private SynapseXPath source = null;

    public SynapseXPath getSource() {
        return this.source;
    }

    public void setSource(SynapseXPath source) {
        this.source = source;
    }

    public String getTagLocalName() {
        return "switch";
    }

    public OMElement serialize(OMElement parent) {
        OMElement switchMed = fac.createOMElement("switch", synNS);
        SwitchMediator.saveTracingState((OMElement)switchMed, (Mediator)this);
        if (this.getSource() == null) {
            throw new MediatorException("Invalid switch mediator. Source required");
        }
        SynapseXPathSerializer.serializeXPath((SynapseXPath)this.getSource(), (OMElement)switchMed, (String)"source");
        this.serializeChildren(switchMed, this.getList());
        if (parent != null) {
            parent.addChild((OMNode)switchMed);
        }
        return switchMed;
    }

    public void build(OMElement elem) {
        OMAttribute source;
        if (this.getList() != null) {
            this.getList().clear();
        }
        if ((source = elem.getAttribute(ATT_SOURCE)) == null) {
            String msg = "A 'source' XPath attribute is required for a switch mediator";
            throw new MediatorException(msg);
        }
        try {
            this.setSource(SynapseXPathFactory.getSynapseXPath((OMElement)elem, (QName)ATT_SOURCE));
        }
        catch (JaxenException e) {
            String msg = "Invalid XPath for attribute 'source' : " + source.getAttributeValue();
            throw new MediatorException(msg);
        }
        this.processAuditStatus((Mediator)this, elem);
        this.addChildren(elem, (ListMediator)this);
    }
}

