/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mediator.switchm;

import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.wso2.carbon.mediator.service.MediatorException;
import org.wso2.carbon.mediator.service.ui.AbstractListMediator;
import org.wso2.carbon.mediator.service.ui.ListMediator;
import org.wso2.carbon.mediator.service.ui.Mediator;

public class SwitchCaseMediator
extends AbstractListMediator {
    private Pattern regex = null;

    public Pattern getRegex() {
        return this.regex;
    }

    public void setRegex(Pattern regex) {
        this.regex = regex;
    }

    public String getTagLocalName() {
        return "case";
    }

    public OMElement serialize(OMElement parent) {
        OMElement caseElem = fac.createOMElement("case", synNS);
        SwitchCaseMediator.saveTracingState((OMElement)caseElem, (Mediator)this);
        if (this.regex == null) {
            throw new MediatorException("Invalid switch case. Regex required");
        }
        caseElem.addAttribute(fac.createOMAttribute("regex", nullNS, this.regex.pattern()));
        this.serializeChildren(caseElem, this.getList());
        if (parent != null) {
            parent.addChild((OMNode)caseElem);
        }
        return caseElem;
    }

    public void build(OMElement elem) {
        this.regex = null;
        OMAttribute regex = elem.getAttribute(ATT_REGEX);
        if (regex == null) {
            String msg = "The 'regex' attribute is required for a switch case definition";
            throw new MediatorException(msg);
        }
        try {
            this.regex = Pattern.compile(regex.getAttributeValue());
        }
        catch (PatternSyntaxException pse) {
            String msg = "Invalid Regular Expression for attribute 'regex' : " + regex.getAttributeValue();
            throw new MediatorException(msg);
        }
        this.processAuditStatus((Mediator)this, elem);
        this.addChildren(elem, (ListMediator)this);
    }
}

