/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mediator.dbreport;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.synapse.util.xpath.SynapseXPath;
import org.wso2.carbon.mediator.service.MediatorException;

public class Statement {
    private String rawStatement = null;
    private final List<Parameter> parameters = new ArrayList<Parameter>();
    private final Map<String, String> resultsMap = new HashMap<String, String>();

    public Statement(String rawStatement) {
        this.rawStatement = rawStatement;
    }

    public String getRawStatement() {
        return this.rawStatement;
    }

    public void addParameter(String propertyName, SynapseXPath xpath, String type) {
        this.parameters.add(new Parameter(propertyName, xpath, type));
    }

    public void addResult(String propertyName, String column) {
        this.resultsMap.put(propertyName, column);
    }

    public List<Parameter> getParameters() {
        return this.parameters;
    }

    public Map<String, String> getResultsMap() {
        return this.resultsMap;
    }

    public class Parameter {
        String propertyName = null;
        SynapseXPath xpath = null;
        int type = 0;

        Parameter(String value, SynapseXPath xpath, String type) {
            this.propertyName = value;
            this.xpath = xpath;
            if ("CHAR".equals(type)) {
                this.type = 1;
            } else if ("VARCHAR".equals(type)) {
                this.type = 12;
            } else if ("LONGVARCHAR".equals(type)) {
                this.type = -1;
            } else if ("NUMERIC".equals(type)) {
                this.type = 2;
            } else if ("DECIMAL".equals(type)) {
                this.type = 3;
            } else if ("BIT".equals(type)) {
                this.type = -7;
            } else if ("TINYINT".equals(type)) {
                this.type = -6;
            } else if ("SMALLINT".equals(type)) {
                this.type = 5;
            } else if ("INTEGER".equals(type)) {
                this.type = 4;
            } else if ("BIGINT".equals(type)) {
                this.type = -5;
            } else if ("REAL".equals(type)) {
                this.type = 7;
            } else if ("FLOAT".equals(type)) {
                this.type = 6;
            } else if ("DOUBLE".equals(type)) {
                this.type = 8;
            } else if ("DATE".equals(type)) {
                this.type = 91;
            } else if ("TIME".equals(type)) {
                this.type = 92;
            } else if ("TIMESTAMP".equals(type)) {
                this.type = 93;
            } else {
                throw new MediatorException("Unknown or unsupported JDBC type : " + type);
            }
        }

        public String getPropertyName() {
            return this.propertyName;
        }

        public SynapseXPath getXpath() {
            return this.xpath;
        }

        public int getType() {
            return this.type;
        }
    }
}

