/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mediator.dbreport;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMText;
import org.apache.synapse.config.xml.SynapseXPathFactory;
import org.apache.synapse.config.xml.SynapseXPathSerializer;
import org.apache.synapse.util.xpath.SynapseXPath;
import org.jaxen.JaxenException;
import org.wso2.carbon.mediator.dbreport.Statement;
import org.wso2.carbon.mediator.service.MediatorException;
import org.wso2.carbon.mediator.service.ui.AbstractMediator;
import org.wso2.carbon.mediator.service.ui.Mediator;

public class DBReportMediator
extends AbstractMediator {
    public static final QName URL_Q = new QName("http://ws.apache.org/ns/synapse", "url");
    static final QName DRIVER_Q = new QName("http://ws.apache.org/ns/synapse", "driver");
    static final QName USER_Q = new QName("http://ws.apache.org/ns/synapse", "user");
    static final QName PASS_Q = new QName("http://ws.apache.org/ns/synapse", "password");
    public static final QName DSNAME_Q = new QName("http://ws.apache.org/ns/synapse", "dsName");
    static final QName ICCLASS_Q = new QName("http://ws.apache.org/ns/synapse", "icClass");
    static final QName STMNT_Q = new QName("http://ws.apache.org/ns/synapse", "statement");
    static final QName SQL_Q = new QName("http://ws.apache.org/ns/synapse", "sql");
    static final QName PARAM_Q = new QName("http://ws.apache.org/ns/synapse", "parameter");
    static final QName RESULT_Q = new QName("http://ws.apache.org/ns/synapse", "result");
    static final QName USE_TX_Q = new QName("useTransaction");
    static final QName ATT_COLUMN = new QName("column");
    static final QName ATT_TYPE = new QName("type");
    boolean useTransaction = false;
    protected final Map dataSourceProps = new HashMap();
    private final List<Statement> statementList = new ArrayList<Statement>();

    public void addDataSourceProperty(QName name, String value) {
        this.dataSourceProps.put(name, value);
    }

    public void addDataSourceProperty(String name, String value) {
        this.dataSourceProps.put(name, value);
    }

    public Map getDataSourceProps() {
        return this.dataSourceProps;
    }

    public void addStatement(Statement stmnt) {
        this.statementList.add(stmnt);
    }

    public List getStatementList() {
        return this.statementList;
    }

    public boolean isUseTransaction() {
        return this.useTransaction;
    }

    public void setUseTransaction(boolean useTransaction) {
        this.useTransaction = useTransaction;
    }

    public OMElement serialize(OMElement parent) {
        OMElement dbReport = fac.createOMElement("dbreport", synNS);
        if (this.useTransaction) {
            dbReport.addAttribute(fac.createOMAttribute("useTransaction", nullNS, "true"));
        }
        DBReportMediator.saveTracingState((OMElement)dbReport, (Mediator)this);
        this.serializeDBInformation(dbReport);
        if (parent != null) {
            parent.addChild((OMNode)dbReport);
        }
        return dbReport;
    }

    private void serializeDBInformation(OMElement dbReport) {
        OMElement connElt = fac.createOMElement("connection", synNS);
        OMElement poolElt = fac.createOMElement("pool", synNS);
        for (Object o : this.dataSourceProps.keySet()) {
            String value = (String)this.dataSourceProps.get(o);
            if (o instanceof QName) {
                QName name = (QName)o;
                OMElement elt = fac.createOMElement(name.getLocalPart(), synNS);
                elt.setText(value);
                poolElt.addChild((OMNode)elt);
                continue;
            }
            if (!(o instanceof String)) continue;
            OMElement elt = fac.createOMElement(PROP_Q.getLocalPart(), synNS);
            elt.addAttribute(fac.createOMAttribute("name", nullNS, (String)o));
            elt.addAttribute(fac.createOMAttribute("value", nullNS, value));
            poolElt.addChild((OMNode)elt);
        }
        connElt.addChild((OMNode)poolElt);
        dbReport.addChild((OMNode)connElt);
        for (Statement statement : this.statementList) {
            OMElement stmntElt = fac.createOMElement(STMNT_Q.getLocalPart(), synNS);
            OMElement sqlElt = fac.createOMElement(SQL_Q.getLocalPart(), synNS);
            OMText sqlText = fac.createOMText(statement.getRawStatement(), 12);
            sqlElt.addChild((OMNode)sqlText);
            stmntElt.addChild((OMNode)sqlElt);
            for (Statement.Parameter param : statement.getParameters()) {
                OMElement paramElt = fac.createOMElement(PARAM_Q.getLocalPart(), synNS);
                if (param.getPropertyName() != null) {
                    paramElt.addAttribute(fac.createOMAttribute("value", nullNS, param.getPropertyName()));
                }
                if (param.getXpath() != null) {
                    SynapseXPathSerializer.serializeXPath((SynapseXPath)param.getXpath(), (OMElement)paramElt, (String)"expression");
                }
                switch (param.getType()) {
                    case 1: {
                        paramElt.addAttribute(fac.createOMAttribute("type", nullNS, "CHAR"));
                        break;
                    }
                    case 12: {
                        paramElt.addAttribute(fac.createOMAttribute("type", nullNS, "VARCHAR"));
                        break;
                    }
                    case -1: {
                        paramElt.addAttribute(fac.createOMAttribute("type", nullNS, "LONGVARCHAR"));
                        break;
                    }
                    case 2: {
                        paramElt.addAttribute(fac.createOMAttribute("type", nullNS, "NUMERIC"));
                        break;
                    }
                    case 3: {
                        paramElt.addAttribute(fac.createOMAttribute("type", nullNS, "DECIMAL"));
                        break;
                    }
                    case -7: {
                        paramElt.addAttribute(fac.createOMAttribute("type", nullNS, "BIT"));
                        break;
                    }
                    case -6: {
                        paramElt.addAttribute(fac.createOMAttribute("type", nullNS, "TINYINT"));
                        break;
                    }
                    case 5: {
                        paramElt.addAttribute(fac.createOMAttribute("type", nullNS, "SMALLINT"));
                        break;
                    }
                    case 4: {
                        paramElt.addAttribute(fac.createOMAttribute("type", nullNS, "INTEGER"));
                        break;
                    }
                    case -5: {
                        paramElt.addAttribute(fac.createOMAttribute("type", nullNS, "BIGINT"));
                        break;
                    }
                    case 7: {
                        paramElt.addAttribute(fac.createOMAttribute("type", nullNS, "REAL"));
                        break;
                    }
                    case 6: {
                        paramElt.addAttribute(fac.createOMAttribute("type", nullNS, "FLOAT"));
                        break;
                    }
                    case 8: {
                        paramElt.addAttribute(fac.createOMAttribute("type", nullNS, "DOUBLE"));
                        break;
                    }
                    case 91: {
                        paramElt.addAttribute(fac.createOMAttribute("type", nullNS, "DATE"));
                        break;
                    }
                    case 92: {
                        paramElt.addAttribute(fac.createOMAttribute("type", nullNS, "TIME"));
                        break;
                    }
                    case 93: {
                        paramElt.addAttribute(fac.createOMAttribute("type", nullNS, "TIMESTAMP"));
                        break;
                    }
                    default: {
                        throw new MediatorException("Unknown or unsupported JDBC type : " + param.getType());
                    }
                }
                stmntElt.addChild((OMNode)paramElt);
            }
            for (String name : statement.getResultsMap().keySet()) {
                String columnStr = statement.getResultsMap().get(name);
                OMElement resultElt = fac.createOMElement(RESULT_Q.getLocalPart(), synNS);
                resultElt.addAttribute(fac.createOMAttribute("name", nullNS, name));
                resultElt.addAttribute(fac.createOMAttribute("column", nullNS, columnStr));
                stmntElt.addChild((OMNode)resultElt);
            }
            dbReport.addChild((OMNode)stmntElt);
        }
    }

    public void build(OMElement elem) {
        this.dataSourceProps.clear();
        this.statementList.clear();
        OMAttribute useTx = elem.getAttribute(USE_TX_Q);
        if (useTx != null && useTx.getAttributeValue() != null) {
            String useTxValue = useTx.getAttributeValue();
            this.useTransaction = useTxValue.equals("true");
        }
        this.buildDataSource(elem);
        this.processStatements(elem);
    }

    private void processStatements(OMElement elem) {
        Iterator iter = elem.getChildrenWithName(STMNT_Q);
        while (iter.hasNext()) {
            OMElement stmntElt = (OMElement)iter.next();
            Statement statement = new Statement(this.getValue(stmntElt, SQL_Q));
            Iterator paramIter = stmntElt.getChildrenWithName(PARAM_Q);
            while (paramIter.hasNext()) {
                OMElement paramElt = (OMElement)paramIter.next();
                String xpath = this.getAttribute(paramElt, ATT_EXPRN);
                String value = this.getAttribute(paramElt, ATT_VALUE);
                if (xpath == null && value == null) continue;
                SynapseXPath xp = null;
                if (xpath != null) {
                    try {
                        xp = SynapseXPathFactory.getSynapseXPath((OMElement)paramElt, (QName)ATT_EXPRN);
                    }
                    catch (JaxenException e) {
                        throw new MediatorException("Invalid XPath specified for the source attribute : " + xpath);
                    }
                }
                statement.addParameter(value, xp, this.getAttribute(paramElt, ATT_TYPE));
            }
            Iterator resultIter = stmntElt.getChildrenWithName(RESULT_Q);
            while (resultIter.hasNext()) {
                OMElement resultElt = (OMElement)resultIter.next();
                statement.addResult(this.getAttribute(resultElt, ATT_NAME), this.getAttribute(resultElt, ATT_COLUMN));
            }
            this.statementList.add(statement);
        }
    }

    private void buildDataSource(OMElement elem) {
        block4: {
            OMElement pool = null;
            try {
                SynapseXPath xpath = new SynapseXPath("self::node()/syn:connection/syn:pool");
                xpath.addNamespace("syn", "http://ws.apache.org/ns/synapse");
                pool = (OMElement)xpath.selectSingleNode((Object)elem);
                if (pool.getFirstChildWithName(DRIVER_Q) != null) {
                    this.createCustomDataSource(pool);
                    break block4;
                }
                if (pool.getFirstChildWithName(DSNAME_Q) != null) {
                    this.lookupDataSource(pool);
                    break block4;
                }
                throw new MediatorException("The DataSource connection information must be specified for using a custom DataSource connection pool or for a JNDI lookup");
            }
            catch (JaxenException e) {
                throw new MediatorException("Error looking up DataSource connection information");
            }
        }
    }

    private void lookupDataSource(OMElement pool) {
        String dsName = this.getValue(pool, DSNAME_Q);
        this.dataSourceProps.put(DSNAME_Q, dsName);
        if (this.getValue(pool, ICCLASS_Q) != null) {
            this.dataSourceProps.put(ICCLASS_Q, this.getValue(pool, ICCLASS_Q));
        }
        if (this.getValue(pool, URL_Q) != null) {
            this.dataSourceProps.put(URL_Q, this.getValue(pool, URL_Q));
        }
        if (this.getValue(pool, USER_Q) != null) {
            this.dataSourceProps.put(USER_Q, this.getValue(pool, USER_Q));
        }
        if (this.getValue(pool, PASS_Q) != null) {
            this.dataSourceProps.put(PASS_Q, this.getValue(pool, PASS_Q));
        }
    }

    private void createCustomDataSource(OMElement pool) {
        this.dataSourceProps.put(DRIVER_Q, this.getValue(pool, DRIVER_Q));
        this.dataSourceProps.put(URL_Q, this.getValue(pool, URL_Q));
        this.dataSourceProps.put(USER_Q, this.getValue(pool, USER_Q));
        this.dataSourceProps.put(PASS_Q, this.getValue(pool, PASS_Q));
        Iterator props = pool.getChildrenWithName(PROP_Q);
        while (props.hasNext()) {
            OMElement prop = (OMElement)props.next();
            String name = prop.getAttribute(ATT_NAME).getAttributeValue();
            String value = prop.getAttribute(ATT_VALUE).getAttributeValue();
            this.dataSourceProps.put(name, value);
        }
    }

    protected String getValue(OMElement elt, QName qName) {
        OMElement e = elt.getFirstChildWithName(qName);
        if (e != null) {
            return e.getText();
        }
        return null;
    }

    protected String getAttribute(OMElement elt, QName qName) {
        OMAttribute a = elt.getAttribute(qName);
        if (a != null) {
            return a.getAttributeValue();
        }
        return null;
    }

    public String getTagLocalName() {
        return "dbreport";
    }
}

