/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mediation.templates.ui;

import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Properties;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.config.xml.endpoints.TemplateFactory;
import org.apache.synapse.endpoints.Template;
import org.wso2.carbon.mediation.templates.common.EndpointTemplateInfo;
import org.wso2.carbon.mediation.templates.common.TemplateEditorException;
import org.wso2.carbon.mediation.templates.endpoint.stub.types.EndpointTemplateAdminServiceStub;
import org.wso2.carbon.ui.CarbonUIUtil;

public class EndpointTemplateAdminClient {
    private static final Log log = LogFactory.getLog(EndpointTemplateAdminClient.class);
    private EndpointTemplateAdminServiceStub endpointTemplateAdminStub;

    public EndpointTemplateAdminClient(ServletConfig config, HttpSession session) throws AxisFault {
        String backendServerURL = CarbonUIUtil.getServerURL((ServletContext)config.getServletContext(), (HttpSession)session);
        ConfigurationContext configContext = (ConfigurationContext)config.getServletContext().getAttribute("ConfigurationContext");
        String cookie = (String)session.getAttribute("wso2carbon.admin.service.cookie");
        String serviceURL = backendServerURL + "EndpointTemplateAdminService";
        this.endpointTemplateAdminStub = new EndpointTemplateAdminServiceStub(configContext, serviceURL);
        ServiceClient client = this.endpointTemplateAdminStub._getServiceClient();
        Options option = client.getOptions();
        option.setManageSession(true);
        option.setProperty("Cookie", (Object)cookie);
    }

    public String[] getAllTempalateNames() throws TemplateEditorException {
        EndpointTemplateInfo[] dynamicTempalates;
        EndpointTemplateInfo[] definedTempalates;
        ArrayList<String> templateNames = new ArrayList<String>();
        for (EndpointTemplateInfo definedTempalate : definedTempalates = this.getEndpointTemplates(0, this.getEndpointTemplatesCount())) {
            if (definedTempalate.getTemplateName() == null) continue;
            templateNames.add(definedTempalate.getTemplateName());
        }
        for (EndpointTemplateInfo dynTempalate : dynamicTempalates = this.getDynamicEndpointTemplates(0, this.getDynamicEndpointTemplatesCount())) {
            if (dynTempalate.getTemplateName() == null) continue;
            templateNames.add(dynTempalate.getTemplateName());
        }
        return templateNames.toArray(new String[0]);
    }

    public int getEndpointTemplatesCount() throws TemplateEditorException {
        try {
            return this.endpointTemplateAdminStub.getEndpointTemplatesCount();
        }
        catch (Exception e) {
            this.handleException("Couldn't retrieve the endpoint template count", e);
            return 0;
        }
    }

    public int getDynamicEndpointTemplatesCount() throws TemplateEditorException {
        try {
            return this.endpointTemplateAdminStub.getDynamicEndpointTemplatesCount();
        }
        catch (Exception e) {
            this.handleException("Couldn't retrieve the dynamic endpoint template count", e);
            return 0;
        }
    }

    public EndpointTemplateInfo[] getEndpointTemplates(int pageNumber, int endpointTemplatesPerPage) throws TemplateEditorException {
        ArrayList<EndpointTemplateInfo> templates = new ArrayList<EndpointTemplateInfo>();
        try {
            org.wso2.carbon.mediation.templates.endpoint.stub.types.common.EndpointTemplateInfo[] temp = this.endpointTemplateAdminStub.getEndpointTemplates(pageNumber, endpointTemplatesPerPage);
            if (temp == null || temp.length == 0 || temp[0] == null) {
                return null;
            }
            for (org.wso2.carbon.mediation.templates.endpoint.stub.types.common.EndpointTemplateInfo info : temp) {
                EndpointTemplateInfo templInfo = new EndpointTemplateInfo();
                templInfo.setTemplateName(info.getTemplateName());
                templInfo.setDescription(info.getDescription());
                templInfo.setEndpointType(info.getEndpointType());
                templates.add(templInfo);
            }
        }
        catch (Exception e) {
            this.handleException("Couldn't retrieve the information of the endpoint templates", e);
        }
        if (templates.size() > 0) {
            return templates.toArray(new EndpointTemplateInfo[templates.size()]);
        }
        return null;
    }

    public EndpointTemplateInfo[] getDynamicEndpointTemplates(int pageNumber, int endpointTemplatesPerPage) throws TemplateEditorException {
        ArrayList<EndpointTemplateInfo> templates = new ArrayList<EndpointTemplateInfo>();
        try {
            org.wso2.carbon.mediation.templates.endpoint.stub.types.common.EndpointTemplateInfo[] temp = this.endpointTemplateAdminStub.getDynamicEndpointTemplates(pageNumber, endpointTemplatesPerPage);
            if (temp == null || temp.length == 0 || temp[0] == null) {
                return null;
            }
            for (org.wso2.carbon.mediation.templates.endpoint.stub.types.common.EndpointTemplateInfo info : temp) {
                EndpointTemplateInfo templInfo = new EndpointTemplateInfo();
                templInfo.setTemplateName(info.getTemplateName());
                templInfo.setDescription(info.getDescription());
                templInfo.setEndpointType(info.getEndpointType());
                templates.add(templInfo);
            }
        }
        catch (Exception e) {
            this.handleException("Couldn't retrieve the information of the endpoint templates", e);
        }
        if (templates.size() > 0) {
            return templates.toArray(new EndpointTemplateInfo[templates.size()]);
        }
        return null;
    }

    public Template getTempalate(String templateName) throws RemoteException, TemplateEditorException {
        OMElement element = null;
        Template template = null;
        try {
            element = this.endpointTemplateAdminStub.getTemplate(templateName).getFirstElement();
            template = new TemplateFactory().createEndpointTemplate(element, new Properties());
        }
        catch (Exception e) {
            this.handleException("Couldn't retrieve the endpoint template element with name '" + templateName + "'", e);
        }
        return template;
    }

    public void saveTemplate(String templateConfig) throws TemplateEditorException {
        try {
            this.endpointTemplateAdminStub.saveEndpointTemplate(templateConfig);
        }
        catch (Exception e) {
            this.handleException("Error in saving the template with the configuration ", e);
        }
    }

    public void saveDynamicTemplate(String key, String templateConfig) throws TemplateEditorException {
        try {
            this.endpointTemplateAdminStub.saveDynamicEndpointTemplate(key, templateConfig);
        }
        catch (Exception e) {
            this.handleException("Error in saving the template with the configuration ", e);
        }
    }

    public void addTemplate(String templateConfig) throws TemplateEditorException {
        try {
            this.endpointTemplateAdminStub.addEndpointTemplate(templateConfig);
        }
        catch (Exception e) {
            this.handleException("Error in adding the template with the configuration ", e);
        }
    }

    public void addDynamicTemplate(String key, String templateConfig) throws TemplateEditorException {
        try {
            this.endpointTemplateAdminStub.addDynamicEndpointTemplate(key, templateConfig);
        }
        catch (Exception e) {
            this.handleException("Error in adding the template with the configuration ", e);
        }
    }

    private void handleException(String message, Throwable e) throws TemplateEditorException {
        log.error((Object)message, e);
        throw new TemplateEditorException(message, e);
    }

    public void deleteTemplate(String templateName) throws TemplateEditorException {
        try {
            this.endpointTemplateAdminStub.deleteEndpointTemplate(templateName);
        }
        catch (Exception e) {
            this.handleException("Couldn't delete the endpoint template '" + templateName + "'", e);
        }
    }

    public void deleteDynamicTemplate(String templateName) throws TemplateEditorException {
        try {
            this.endpointTemplateAdminStub.deleteDynamicEndpointTemplate(templateName);
        }
        catch (Exception e) {
            this.handleException("Couldn't delete the endpoint template '" + templateName + "'", e);
        }
    }
}

