/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.message.processor.ui;

import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.message.store.stub.MessageStoreAdminServiceStub;

public class MessageStoreAdminServiceClient {
    private MessageStoreAdminServiceStub stub;
    private static final String adminServiceName = "MessageStoreAdminService";
    private static Log log = LogFactory.getLog(MessageStoreAdminServiceClient.class);

    public MessageStoreAdminServiceClient(String cookie, String backendServerUrl, ConfigurationContext configurationContext) throws AxisFault {
        String serviceURL = backendServerUrl + adminServiceName;
        this.stub = new MessageStoreAdminServiceStub(configurationContext, serviceURL);
        ServiceClient client = this.stub._getServiceClient();
        Options option = client.getOptions();
        option.setManageSession(true);
        option.setProperty("Cookie", (Object)cookie);
    }

    public String[] getMessageStoreNames() throws Exception {
        String[] messageStoreNames = null;
        try {
            messageStoreNames = this.stub.getMessageStoreNames();
        }
        catch (Exception e) {
            String message = "Error While Accessing Message Store admin Service " + e.getMessage();
            log.error((Object)message, (Throwable)e);
            throw e;
        }
        return messageStoreNames;
    }

    public String getMessageStoreClass(String messageStoreName) throws Exception {
        String messageStoreClassName = null;
        try {
            messageStoreClassName = this.stub.getClassName(messageStoreName);
        }
        catch (Exception e) {
            String message = "Error While Accessing Message Store admin Service " + e.getMessage();
            log.error((Object)message, (Throwable)e);
            throw e;
        }
        return messageStoreClassName;
    }
}

