/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context.annotation;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.parsing.Location;
import org.springframework.beans.factory.parsing.Problem;
import org.springframework.beans.factory.parsing.ProblemReporter;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.BeanMethod;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.ComponentScanAnnotationParser;
import org.springframework.context.annotation.ConfigurationClass;
import org.springframework.context.annotation.ConfigurationClassUtils;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.context.annotation.ImportResource;
import org.springframework.context.annotation.ImportSelector;
import org.springframework.context.annotation.ProfileHelper;
import org.springframework.context.annotation.PropertySource;
import org.springframework.core.env.Environment;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.ResourcePropertySource;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.core.type.MethodMetadata;
import org.springframework.core.type.StandardAnnotationMetadata;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.core.type.classreading.MetadataReaderFactory;
import org.springframework.core.type.filter.AssignableTypeFilter;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ConfigurationClassParser {
    private final MetadataReaderFactory metadataReaderFactory;
    private final ProblemReporter problemReporter;
    private final ImportStack importStack = new ImportStack();
    private final Set<ConfigurationClass> configurationClasses = new LinkedHashSet<ConfigurationClass>();
    private final Stack<org.springframework.core.env.PropertySource<?>> propertySources = new Stack();
    private final Environment environment;
    private final ResourceLoader resourceLoader;
    private final BeanDefinitionRegistry registry;
    private final ComponentScanAnnotationParser componentScanParser;

    public ConfigurationClassParser(MetadataReaderFactory metadataReaderFactory, ProblemReporter problemReporter, Environment environment, ResourceLoader resourceLoader, BeanDefinitionRegistry registry) {
        this.metadataReaderFactory = metadataReaderFactory;
        this.problemReporter = problemReporter;
        this.environment = environment;
        this.resourceLoader = resourceLoader;
        this.registry = registry;
        this.componentScanParser = new ComponentScanAnnotationParser(this.resourceLoader, this.environment, this.registry);
    }

    public void parse(String className, String beanName) throws IOException {
        MetadataReader reader = this.metadataReaderFactory.getMetadataReader(className);
        this.processConfigurationClass(new ConfigurationClass(reader, beanName));
    }

    public void parse(Class<?> clazz, String beanName) throws IOException {
        this.processConfigurationClass(new ConfigurationClass(clazz, beanName));
    }

    /*
     * Unable to fully structure code
     */
    protected void processConfigurationClass(ConfigurationClass configClass) throws IOException {
        metadata = configClass.getMetadata();
        if (this.environment == null || !ProfileHelper.isProfileAnnotationPresent(metadata) || this.environment.acceptsProfiles(ProfileHelper.getCandidateProfiles(metadata))) ** GOTO lbl15
        return;
lbl-1000:
        // 1 sources

        {
            this.doProcessConfigurationClass(configClass, metadata);
            superClassName = metadata.getSuperClassName();
            if (superClassName != null && !Object.class.getName().equals(superClassName)) {
                if (metadata instanceof StandardAnnotationMetadata) {
                    clazz = ((StandardAnnotationMetadata)metadata).getIntrospectedClass();
                    metadata = new StandardAnnotationMetadata(clazz.getSuperclass());
                    continue;
                }
                reader = this.metadataReaderFactory.getMetadataReader(superClassName);
                metadata = reader.getAnnotationMetadata();
                continue;
            }
            metadata = null;
lbl15:
            // 4 sources

            ** while (metadata != null)
        }
lbl16:
        // 1 sources

        if (this.configurationClasses.contains(configClass) && configClass.getBeanName() != null) {
            this.configurationClasses.remove(configClass);
        }
        this.configurationClasses.add(configClass);
    }

    protected void doProcessConfigurationClass(ConfigurationClass configClass, AnnotationMetadata metadata) throws IOException {
        Map<String, Object> componentScanAttributes;
        int n;
        String[] stringArray = metadata.getMemberClassNames();
        int n2 = stringArray.length;
        int n3 = 0;
        while (n3 < n2) {
            String memberClassName = stringArray[n3];
            MetadataReader reader = this.metadataReaderFactory.getMetadataReader(memberClassName);
            AnnotationMetadata memberClassMetadata = reader.getAnnotationMetadata();
            if (ConfigurationClassUtils.isConfigurationCandidate(memberClassMetadata)) {
                this.processConfigurationClass(new ConfigurationClass(reader, null));
            }
            ++n3;
        }
        Map<String, Object> propertySourceAttributes = metadata.getAnnotationAttributes(PropertySource.class.getName());
        if (propertySourceAttributes != null) {
            String name = (String)propertySourceAttributes.get("name");
            String[] locations = (String[])propertySourceAttributes.get("value");
            ClassLoader classLoader = this.resourceLoader.getClassLoader();
            String[] stringArray2 = locations;
            n = locations.length;
            int memberClassMetadata = 0;
            while (memberClassMetadata < n) {
                Object location = stringArray2[memberClassMetadata];
                location = this.environment.resolveRequiredPlaceholders((String)location);
                ResourcePropertySource ps = StringUtils.hasText(name) ? new ResourcePropertySource(name, (String)location, classLoader) : new ResourcePropertySource((String)location, classLoader);
                this.propertySources.push(ps);
                ++memberClassMetadata;
            }
        }
        if ((componentScanAttributes = metadata.getAnnotationAttributes(ComponentScan.class.getName())) != null) {
            Set<BeanDefinitionHolder> scannedBeanDefinitions = this.componentScanParser.parse(componentScanAttributes);
            for (BeanDefinitionHolder beanDefinitionHolder : scannedBeanDefinitions) {
                if (!ConfigurationClassUtils.checkConfigurationClassCandidate(beanDefinitionHolder.getBeanDefinition(), this.metadataReaderFactory)) continue;
                this.parse(beanDefinitionHolder.getBeanDefinition().getBeanClassName(), beanDefinitionHolder.getBeanName());
            }
        }
        List<Map<String, Object>> allImportAttribs = this.findAllAnnotationAttributes(Import.class, metadata.getClassName(), true);
        for (Map map : allImportAttribs) {
            this.processImport(configClass, (String[])map.get("value"), true);
        }
        if (metadata.isAnnotated(ImportResource.class.getName())) {
            Object[] objectArray = (String[])metadata.getAnnotationAttributes(ImportResource.class.getName()).get("value");
            Class readerClass = (Class)metadata.getAnnotationAttributes(ImportResource.class.getName()).get("reader");
            if (readerClass == null) {
                throw new IllegalStateException("No reader class associated with imported resources: " + StringUtils.arrayToCommaDelimitedString(objectArray));
            }
            Object[] objectArray2 = objectArray;
            int n4 = objectArray.length;
            n = 0;
            while (n < n4) {
                Object resource = objectArray2[n];
                configClass.addImportedResource((String)resource, readerClass);
                ++n;
            }
        }
        Set<MethodMetadata> set = metadata.getAnnotatedMethods(Bean.class.getName());
        for (MethodMetadata methodMetadata : set) {
            configClass.addBeanMethod(new BeanMethod(methodMetadata, configClass));
        }
    }

    private List<Map<String, Object>> findAllAnnotationAttributes(Class<? extends Annotation> targetAnnotation, String annotatedClassName, boolean classValuesAsString) throws IOException {
        ArrayList<Map<String, Object>> allAttribs = new ArrayList<Map<String, Object>>();
        MetadataReader reader = this.metadataReaderFactory.getMetadataReader(annotatedClassName);
        AnnotationMetadata metadata = reader.getAnnotationMetadata();
        String targetAnnotationType = targetAnnotation.getName();
        for (String annotationType : metadata.getAnnotationTypes()) {
            MetadataReader metaReader;
            Map<String, Object> targetAttribs;
            if (annotationType.equals(targetAnnotationType) || (targetAttribs = (metaReader = this.metadataReaderFactory.getMetadataReader(annotationType)).getAnnotationMetadata().getAnnotationAttributes(targetAnnotationType, classValuesAsString)) == null) continue;
            allAttribs.add(targetAttribs);
        }
        Map<String, Object> localAttribs = metadata.getAnnotationAttributes(targetAnnotationType, classValuesAsString);
        if (localAttribs != null) {
            allAttribs.add(localAttribs);
        }
        return allAttribs;
    }

    private void processImport(ConfigurationClass configClass, String[] classesToImport, boolean checkForCircularImports) throws IOException {
        if (checkForCircularImports && this.importStack.contains(configClass)) {
            this.problemReporter.error(new CircularImportProblem(configClass, this.importStack, configClass.getMetadata()));
        } else {
            this.importStack.push(configClass);
            AnnotationMetadata importingClassMetadata = configClass.getMetadata();
            String[] stringArray = classesToImport;
            int n = classesToImport.length;
            int n2 = 0;
            while (n2 < n) {
                String candidate = stringArray[n2];
                MetadataReader reader = this.metadataReaderFactory.getMetadataReader(candidate);
                if (new AssignableTypeFilter(ImportSelector.class).match(reader, this.metadataReaderFactory)) {
                    try {
                        ImportSelector selector = BeanUtils.instantiateClass(Class.forName(candidate), ImportSelector.class);
                        this.processImport(configClass, selector.selectImports(importingClassMetadata), false);
                    }
                    catch (ClassNotFoundException ex) {
                        throw new IllegalStateException(ex);
                    }
                } else if (new AssignableTypeFilter(ImportBeanDefinitionRegistrar.class).match(reader, this.metadataReaderFactory)) {
                    try {
                        ImportBeanDefinitionRegistrar registrar = BeanUtils.instantiateClass(Class.forName(candidate), ImportBeanDefinitionRegistrar.class);
                        registrar.registerBeanDefinitions(importingClassMetadata, this.registry);
                    }
                    catch (ClassNotFoundException ex) {
                        throw new IllegalStateException(ex);
                    }
                } else {
                    this.importStack.registerImport(importingClassMetadata.getClassName(), candidate);
                    this.processConfigurationClass(new ConfigurationClass(reader, null));
                }
                ++n2;
            }
            this.importStack.pop();
        }
    }

    public void validate() {
        for (ConfigurationClass configClass : this.configurationClasses) {
            configClass.validate(this.problemReporter);
        }
    }

    public Set<ConfigurationClass> getConfigurationClasses() {
        return this.configurationClasses;
    }

    public Stack<org.springframework.core.env.PropertySource<?>> getPropertySources() {
        return this.propertySources;
    }

    public ImportRegistry getImportRegistry() {
        return this.importStack;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CircularImportProblem
    extends Problem {
        public CircularImportProblem(ConfigurationClass attemptedImport, Stack<ConfigurationClass> importStack, AnnotationMetadata metadata) {
            super(String.format("A circular @Import has been detected: Illegal attempt by @Configuration class '%s' to import class '%s' as '%s' is already present in the current import stack [%s]", importStack.peek().getSimpleName(), attemptedImport.getSimpleName(), attemptedImport.getSimpleName(), importStack), new Location(importStack.peek().getResource(), metadata));
        }
    }

    static interface ImportRegistry {
        public String getImportingClassFor(String var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ImportStack
    extends Stack<ConfigurationClass>
    implements ImportRegistry {
        private Map<String, String> imports = new HashMap<String, String>();

        private ImportStack() {
        }

        @Override
        public String getImportingClassFor(String importedClass) {
            return this.imports.get(importedClass);
        }

        public void registerImport(String importingClass, String importedClass) {
            this.imports.put(importedClass, importingClass);
        }

        @Override
        public boolean contains(Object elem) {
            ConfigurationClass configClass = (ConfigurationClass)elem;
            Comparator<ConfigurationClass> comparator = new Comparator<ConfigurationClass>(){

                @Override
                public int compare(ConfigurationClass first, ConfigurationClass second) {
                    return first.getMetadata().getClassName().equals(second.getMetadata().getClassName()) ? 0 : 1;
                }
            };
            return Collections.binarySearch(this, configClass, comparator) != -1;
        }

        @Override
        public String toString() {
            StringBuilder builder = new StringBuilder("ImportStack: [");
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                builder.append(((ConfigurationClass)iterator.next()).getSimpleName());
                if (!iterator.hasNext()) continue;
                builder.append("->");
            }
            return builder.append(']').toString();
        }
    }
}

