/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.aarservices.ui.fileupload;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.wso2.carbon.CarbonException;
import org.wso2.carbon.aarservices.stub.types.carbon.AARServiceData;
import org.wso2.carbon.aarservices.ui.fileupload.ServiceUploaderClient;
import org.wso2.carbon.ui.CarbonUIMessage;
import org.wso2.carbon.ui.transports.fileupload.AbstractFileUploadExecutor;
import org.wso2.carbon.utils.FileItemData;

public class ServiceFileUploadExecutor
extends AbstractFileUploadExecutor {
    private static final String[] ALLOWED_FILE_EXTENSIONS = new String[]{".aar"};

    public boolean execute(HttpServletRequest request, HttpServletResponse response) throws CarbonException, IOException {
        String webContext = (String)request.getAttribute("WebContext");
        String serverURL = (String)request.getAttribute("ServerURL");
        String cookie = (String)request.getAttribute("wso2carbon.admin.service.cookie");
        Map fileItemsMap = this.getFileItemsMap();
        if (fileItemsMap == null || fileItemsMap.isEmpty()) {
            String msg = "File uploading failed. No files are specified";
            log.error((Object)msg);
            CarbonUIMessage.sendCarbonUIMessage((String)msg, (String)"error", (HttpServletRequest)request, (HttpServletResponse)response, (String)(this.getContextRoot(request) + "/" + webContext + "/aarservices/index.jsp"));
            return false;
        }
        ServiceUploaderClient serviceUploaderClient = new ServiceUploaderClient(this.configurationContext, serverURL, cookie);
        Map formFieldsMap = this.getFormFieldsMap();
        List serviceHierarchies = (List)formFieldsMap.get("serviceHierarchy");
        List fileItems = (List)fileItemsMap.get("aarFilename");
        ArrayList<AARServiceData> serviceDataList = new ArrayList<AARServiceData>();
        try {
            for (int i = 0; i < serviceHierarchies.size(); ++i) {
                String filename = this.getFileName(((FileItemData)fileItems.get(i)).getFileItem().getName());
                this.checkServiceFileExtensionValidity(filename, ALLOWED_FILE_EXTENSIONS);
                if (!filename.endsWith(".aar")) {
                    throw new CarbonException("File with extension " + this.getFileName(((FileItemData)fileItems.get(i)).getFileItem().getName()) + " is not supported!");
                }
                AARServiceData serviceData = new AARServiceData();
                serviceData.setFileName(filename);
                serviceData.setServiceHierarchy((String)serviceHierarchies.get(i));
                serviceData.setDataHandler(((FileItemData)fileItems.get(i)).getDataHandler());
                serviceDataList.add(serviceData);
            }
            serviceUploaderClient.uploadService(serviceDataList.toArray(new AARServiceData[serviceDataList.size()]));
            response.setContentType("text/html; charset=utf-8");
            String msg = "Files have been uploaded successfully. Please refresh this page in a while to see the status of the created Axis2 service";
            CarbonUIMessage.sendCarbonUIMessage((String)msg, (String)"info", (HttpServletRequest)request, (HttpServletResponse)response, (String)(this.getContextRoot(request) + "/" + webContext + "/service-mgt/index.jsp"));
            return true;
        }
        catch (Exception e) {
            String msg = "File upload failed. " + e.getMessage();
            log.error((Object)msg);
            CarbonUIMessage.sendCarbonUIMessage((String)msg, (String)"error", (HttpServletRequest)request, (HttpServletResponse)response, (String)(this.getContextRoot(request) + "/" + webContext + "/aarservices/index.jsp"));
            return false;
        }
    }
}

