/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mediation.configadmin;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.service.component.ComponentContext;
import org.wso2.carbon.mediation.configadmin.util.ConfigHolder;
import org.wso2.carbon.mediation.dependency.mgt.services.ConfigurationTrackingService;
import org.wso2.carbon.mediation.initializer.services.SynapseRegistrationsService;

public class ConfigAdminServiceComponent {
    private static final Log log = LogFactory.getLog(ConfigAdminServiceComponent.class);

    protected void activate(ComponentContext cmpCtx) {
        ConfigHolder.getInstance().setBundleContext(cmpCtx.getBundleContext());
    }

    protected void setSynapseRegistrationsService(SynapseRegistrationsService synapseRegistrationsService) {
        ConfigHolder.getInstance().addSynapseRegistrationService(synapseRegistrationsService.getTenantId(), synapseRegistrationsService);
    }

    protected void unsetSynapseRegistrationsService(SynapseRegistrationsService synapseRegistrationsService) {
        ConfigHolder.getInstance().removeSynapseRegistrationService(synapseRegistrationsService.getTenantId());
    }

    protected void setConfigTrackingService(ConfigurationTrackingService configTrackingService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"ConfigurationTrackingService bound to the ESB initialization process");
        }
        ConfigHolder.getInstance().setSynapseConfigTrackingService(configTrackingService);
    }

    protected void unsetConfigTrackingService(ConfigurationTrackingService configTrackingService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"ConfigurationTrackingService unbound from the ESB environment");
        }
        ConfigHolder.getInstance().setSynapseConfigTrackingService(null);
    }
}

