/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mediation.statistics.monitor;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.aspects.ComponentType;
import org.apache.synapse.commons.jmx.MBeanRegistrar;
import org.wso2.carbon.mediation.statistics.MediationStatisticsObserver;
import org.wso2.carbon.mediation.statistics.MediationStatisticsSnapshot;
import org.wso2.carbon.mediation.statistics.MessageTraceLog;
import org.wso2.carbon.mediation.statistics.StatisticsRecord;
import org.wso2.carbon.mediation.statistics.monitor.EndpointOperationStatView;
import org.wso2.carbon.mediation.statistics.monitor.EndpointStatView;
import org.wso2.carbon.mediation.statistics.monitor.EsbStatView;
import org.wso2.carbon.mediation.statistics.monitor.MemoryStatView;
import org.wso2.carbon.mediation.statistics.monitor.SequenceStatView;
import org.wso2.carbon.mediation.statistics.monitor.StatScheduler;
import org.wso2.carbon.utils.CarbonUtils;

public class EsbStatisticsConsumer
implements MediationStatisticsObserver {
    private static final Log log = LogFactory.getLog(EsbStatisticsConsumer.class);
    private static final String SEQUENCE_MONITOR = "Sequence-Monitor";
    private static final String ENDPOINT_MONITOR = "Endpoint-Monitor";
    private static final String ENDPOINT_OPERATION_MONITOR = "Endpoint-Operation-Monitor";
    private static final String MEMORY_MONITOR = "Memory-Monitor";
    private static final String ESB_MONITOR = "ESB-Monitor";
    private static final String MEMORY_ID = "system-memory";
    private static final String ESB_ID = "entire-esb";
    private static final String STAT_PROP_XML = "stat-properties.xml";
    private static final float MEGA = 1048576.0f;
    private Map<String, SequenceStatView> sequenceViewMap;
    private Map<String, EndpointStatView> endpointViewMap;
    private Map<String, EndpointOperationStatView> endpointOperationViewMap;
    private MemoryStatView memoryView;
    private EsbStatView esbView;
    private Map<String, String> registeredMbeanIds;
    private Map<String, String> endpointThresholds;
    private volatile List<StatisticsRecord> lastMinRecords;
    private ReentrantLock lock = new ReentrantLock();

    public EsbStatisticsConsumer() {
        this.sequenceViewMap = new HashMap<String, SequenceStatView>();
        this.endpointViewMap = new HashMap<String, EndpointStatView>();
        this.endpointOperationViewMap = new HashMap<String, EndpointOperationStatView>();
        this.registeredMbeanIds = new HashMap<String, String>();
        this.endpointThresholds = new HashMap<String, String>();
        this.lastMinRecords = new ArrayList<StatisticsRecord>();
        this.readStatProperties();
        new StatScheduler(this).schedule();
    }

    @Override
    public void destroy() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Destroying all the MBeans in the custom statistics consumer");
        }
        for (String key : this.registeredMbeanIds.keySet()) {
            MBeanRegistrar.getInstance().unRegisterMBean(key, this.registeredMbeanIds.get(key));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateStatistics(MediationStatisticsSnapshot mediationStatisticsSnapshot) {
        this.lock.lock();
        StatisticsRecord record = mediationStatisticsSnapshot.getUpdate();
        try {
            this.lastMinRecords.add(new StatisticsRecord(record));
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void notifyTraceLogs(MessageTraceLog[] messageTraceLogs) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateStatistics(StatisticsRecord updateRecord, StatisticsRecord entitySnap, StatisticsRecord categorySnapshot) {
        this.lock.lock();
        try {
            this.lastMinRecords.add(new StatisticsRecord(updateRecord));
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exposeData() {
        this.lock.lock();
        try {
            for (StatisticsRecord record : this.lastMinRecords) {
                this.exposeDataOnMBeans(record);
            }
            this.lastMinRecords.clear();
        }
        finally {
            this.lock.unlock();
        }
        for (String key : this.endpointViewMap.keySet()) {
            EndpointStatView endpointView = this.endpointViewMap.get(key);
            if (this.endpointThresholds.get(key) == null) continue;
            long threshold = Long.parseLong(this.endpointThresholds.get(key));
            if (endpointView.getTransactionsIn() < threshold) {
                endpointView.setActive(false);
                continue;
            }
            endpointView.setActive(true);
        }
    }

    private void exposeDataOnMBeans(StatisticsRecord updateRecord) {
        ComponentType type = updateRecord.getType();
        if (type == ComponentType.SEQUENCE) {
            SequenceStatView view;
            if (!this.sequenceViewMap.containsKey(updateRecord.getResourceId())) {
                view = new SequenceStatView();
                MBeanRegistrar.getInstance().registerMBean((Object)view, SEQUENCE_MONITOR, updateRecord.getResourceId());
                this.registeredMbeanIds.put(SEQUENCE_MONITOR, updateRecord.getResourceId());
                this.sequenceViewMap.put(updateRecord.getResourceId(), view);
            } else {
                view = this.sequenceViewMap.get(updateRecord.getResourceId());
            }
            this.updateCommonView(view, updateRecord);
        }
        if (updateRecord.isInStatistic() && type == ComponentType.ENDPOINT) {
            EndpointOperationStatView endpointOpView;
            EndpointStatView endpointView;
            String endpointName = this.getEndpointName(updateRecord.getResourceId());
            if (!this.endpointViewMap.containsKey(endpointName)) {
                endpointView = new EndpointStatView();
                MBeanRegistrar.getInstance().registerMBean((Object)endpointView, ENDPOINT_MONITOR, endpointName);
                this.registeredMbeanIds.put(ENDPOINT_MONITOR, endpointName);
                this.endpointViewMap.put(endpointName, endpointView);
            } else {
                endpointView = this.endpointViewMap.get(endpointName);
            }
            this.updateEndpointView(endpointView, updateRecord);
            if (!this.endpointOperationViewMap.containsKey(updateRecord.getResourceId())) {
                endpointOpView = new EndpointOperationStatView();
                MBeanRegistrar.getInstance().registerMBean((Object)endpointOpView, ENDPOINT_OPERATION_MONITOR, updateRecord.getResourceId());
                this.registeredMbeanIds.put(ENDPOINT_OPERATION_MONITOR, updateRecord.getResourceId());
                this.endpointOperationViewMap.put(updateRecord.getResourceId(), endpointOpView);
            } else {
                endpointOpView = this.endpointOperationViewMap.get(updateRecord.getResourceId());
            }
            this.updateEndpointOperationView(endpointOpView, updateRecord);
            if (this.esbView == null) {
                this.esbView = new EsbStatView();
                MBeanRegistrar.getInstance().registerMBean((Object)this.esbView, ESB_MONITOR, ESB_ID);
                this.registeredMbeanIds.put(ESB_MONITOR, ESB_ID);
            }
            this.updateEsbView(this.esbView, updateRecord);
        }
        if (this.memoryView == null) {
            this.memoryView = new MemoryStatView();
            MBeanRegistrar.getInstance().registerMBean((Object)this.memoryView, MEMORY_MONITOR, MEMORY_ID);
            this.registeredMbeanIds.put(MEMORY_MONITOR, MEMORY_ID);
        }
        this.updateMemoryView(this.memoryView);
    }

    private void updateCommonView(SequenceStatView view, StatisticsRecord update) {
        long updatedTotalCount = view.getTransactionsIn() + (long)update.getTotalCount();
        long updateFaultCount = view.getNumberOfErrorsIn() + (long)update.getFaultCount();
        if (updatedTotalCount > 0L) {
            view.setAvgTimeInLastMin((view.getAvgTimeIn() * (double)view.getTransactionsIn() + update.getAvgTime() * (double)update.getTotalCount()) / (double)updatedTotalCount);
            view.setAvgMediationTimeInLastMin(-1.0);
            view.setAvgMediationTimeInLastMin(-1.0);
            view.setErrorPercentageInLastMin(updateFaultCount / updatedTotalCount * 100L);
        }
        view.setNumberOfErrorsInLastMin(updateFaultCount);
        view.setTransactionsInLastMin(updatedTotalCount);
    }

    private void updateEndpointView(EndpointStatView view, StatisticsRecord update) {
        view.setTransactionsInLastMin(view.getTransactionsIn() + (long)update.getTotalCount());
    }

    private void updateEndpointOperationView(EndpointOperationStatView view, StatisticsRecord update) {
        long updatedTotalCount = view.getTransactionsIn() + (long)update.getTotalCount();
        double totalTime = view.getAverageTransactionDurationIn() * (double)view.getTransactionsIn() + update.getAvgTime() * (double)update.getTotalCount();
        if (updatedTotalCount > 0L && totalTime > 0.0) {
            view.setAvgTransactionDurationInLastMin(totalTime / (double)updatedTotalCount);
        }
        view.setTransactionsInLastMin(updatedTotalCount);
    }

    private void updateEsbView(EsbStatView view, StatisticsRecord update) {
        long totalTransactions = view.getTransactionsIn() + (long)update.getTotalCount();
        long totalErrors = view.getErrorsIn() + (long)update.getFaultCount();
        view.setTransactionsInLastMin(totalTransactions);
        view.setErrorsInLastMin(totalErrors);
        if (totalTransactions > 0L) {
            view.setErrorPercentageInLastMin(totalErrors * 100L / totalTransactions);
        }
    }

    private void updateMemoryView(MemoryStatView view) {
        Runtime runtime = Runtime.getRuntime();
        view.setTotalMemory((float)runtime.totalMemory() / 1048576.0f);
        view.setFreeMemory((float)runtime.freeMemory() / 1048576.0f);
        view.setUsedMemory((float)(runtime.totalMemory() - runtime.freeMemory()) / 1048576.0f);
        view.setMaxMemory((float)runtime.maxMemory() / 1048576.0f);
    }

    private void readStatProperties() {
        String statPropPath = CarbonUtils.getCarbonHome() + "/conf/" + STAT_PROP_XML;
        File f = new File(statPropPath);
        if (!f.exists()) {
            log.error((Object)("stat-properties.xml file not found at : " + statPropPath));
            return;
        }
        try {
            FileInputStream xmlInputStream = new FileInputStream(f);
            OMElement documentElement = new StAXOMBuilder((InputStream)xmlInputStream).getDocumentElement();
            OMElement endpointPropElement = documentElement.getFirstChildWithName(new QName("endpointProperties"));
            Iterator itr = endpointPropElement.getChildrenWithLocalName("endpoint");
            String threshold = null;
            while (itr.hasNext()) {
                OMElement endpoint = (OMElement)itr.next();
                String name = this.readAttribute(endpoint, "name");
                OMElement thresholdEle = endpoint.getFirstChildWithName(new QName("threshold"));
                if (thresholdEle != null) {
                    threshold = thresholdEle.getText();
                }
                if (name == null || threshold == null) continue;
                this.endpointThresholds.put(name, threshold);
            }
        }
        catch (Exception e) {
            log.error((Object)"Error while parsing file : stat-properties.xml", (Throwable)e);
        }
    }

    private String readAttribute(OMElement element, String attName) {
        if (element == null) {
            return null;
        }
        OMAttribute temp = element.getAttribute(new QName(attName));
        if (temp != null) {
            return temp.getAttributeValue();
        }
        return null;
    }

    private String getEndpointName(String resId) {
        String[] temp = resId.split("__");
        return temp[0];
    }
}

