/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mediation.statistics;

import java.util.List;
import org.apache.log4j.Logger;
import org.apache.synapse.aspects.ComponentType;
import org.wso2.carbon.mediation.statistics.MediationStatisticsException;
import org.wso2.carbon.mediation.statistics.StatisticsRecord;

public class StatisticsUtil {
    private static Logger log = Logger.getLogger(StatisticsUtil.class);
    public static final String ENDPOINT_CATEGORY = "endpoint";
    public static final String PROXY_SERVICE_CATEGORY = "proxy-service";
    public static final String SEQUENCE_CATEGORY = "sequence";
    public static final String IN_DIRECTION = "in";
    public static final String OUT_DIRECTION = "out";

    public static StatisticsRecord getCombinedRecord(List<StatisticsRecord> records) {
        if (records == null || records.size() == 0) {
            return null;
        }
        StatisticsRecord combinedRecord = new StatisticsRecord(records.get(0));
        records.remove(0);
        for (StatisticsRecord r : records) {
            combinedRecord.updateRecord(r);
        }
        return combinedRecord;
    }

    public static ComponentType getComponentType(int type) {
        switch (type) {
            case 0: {
                return ComponentType.ENDPOINT;
            }
            case 1: {
                return ComponentType.PROXYSERVICE;
            }
            case 2: {
                return ComponentType.SEQUENCE;
            }
        }
        return null;
    }

    public static String getCategory(long category) throws MediationStatisticsException {
        switch ((int)category) {
            case 0: {
                return ENDPOINT_CATEGORY;
            }
            case 1: {
                return PROXY_SERVICE_CATEGORY;
            }
            case 2: {
                return SEQUENCE_CATEGORY;
            }
        }
        StatisticsUtil.handleException("Unknown category");
        return "";
    }

    public static String getDirection(long direction) throws MediationStatisticsException {
        switch ((int)direction) {
            case 0: {
                return IN_DIRECTION;
            }
            case 1: {
                return OUT_DIRECTION;
            }
        }
        StatisticsUtil.handleException("Unknown direction");
        return "";
    }

    public static long getCategory(String catetory) throws MediationStatisticsException {
        if (ENDPOINT_CATEGORY.equals(catetory)) {
            return 0L;
        }
        if (PROXY_SERVICE_CATEGORY.equals(catetory)) {
            return 1L;
        }
        if (SEQUENCE_CATEGORY.equals(catetory)) {
            return 2L;
        }
        StatisticsUtil.handleException("Unknow category " + catetory);
        return -1L;
    }

    public static long getDirection(String direction) throws MediationStatisticsException {
        if (IN_DIRECTION.equals(direction)) {
            return 0L;
        }
        if (OUT_DIRECTION.equals(direction)) {
            return 1L;
        }
        StatisticsUtil.handleException("Unknown direction " + direction);
        return -1L;
    }

    private static void handleException(String msg) throws MediationStatisticsException {
        log.error((Object)msg);
        throw new MediationStatisticsException(msg);
    }
}

