/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mediation.statistics;

import org.apache.synapse.aspects.ComponentType;
import org.apache.synapse.aspects.statistics.view.Statistics;

public class StatisticsRecord {
    public static final long DEFAULT_MIN_TIME = -1L;
    private int totalCount = 0;
    private int faultCount = 0;
    private long maxTime = 0L;
    private long minTime = -1L;
    private double avgTime = 0.0;
    private boolean inStatistic = false;
    private String resourceId = null;
    private ComponentType type = null;

    public StatisticsRecord(String resourceId, ComponentType type, boolean inStatistic, Statistics data) {
        this.resourceId = resourceId;
        this.type = type;
        this.inStatistic = inStatistic;
        if (data != null) {
            this.totalCount = data.getCount();
            this.faultCount = data.getFaultCount();
            this.maxTime = data.getMaxProcessingTime();
            this.minTime = data.getMinProcessingTime();
            this.avgTime = data.getAvgProcessingTime();
        }
    }

    public StatisticsRecord(StatisticsRecord record) {
        this.resourceId = record.resourceId;
        this.type = record.type;
        this.inStatistic = record.inStatistic;
        this.totalCount = record.totalCount;
        this.faultCount = record.faultCount;
        this.maxTime = record.maxTime;
        this.minTime = record.minTime;
        this.avgTime = record.avgTime;
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public ComponentType getType() {
        return this.type;
    }

    public int getTotalCount() {
        return this.totalCount;
    }

    public void setTotalCount(int totalCount) {
        this.totalCount = totalCount;
    }

    public int getFaultCount() {
        return this.faultCount;
    }

    public void setFaultCount(int faultCount) {
        this.faultCount = faultCount;
    }

    public long getMaxTime() {
        return this.maxTime;
    }

    public void setMaxTime(long maxTime) {
        this.maxTime = maxTime;
    }

    public long getMinTime() {
        return this.minTime;
    }

    public void setMinTime(long minTime) {
        this.minTime = minTime;
    }

    public double getAvgTime() {
        return this.avgTime;
    }

    public void setAvgTime(double avgTime) {
        this.avgTime = avgTime;
    }

    public boolean isInStatistic() {
        return this.inStatistic;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateRecord(StatisticsRecord record) {
        int updatedTotalCount = record.getTotalCount() + this.totalCount;
        if (updatedTotalCount > 0) {
            StatisticsRecord statisticsRecord = this;
            synchronized (statisticsRecord) {
                this.faultCount += record.getFaultCount();
                this.avgTime = (record.getAvgTime() * (double)record.getTotalCount() + this.avgTime * (double)this.totalCount) / (double)updatedTotalCount;
                if (record.getMaxTime() > this.maxTime) {
                    this.maxTime = record.getMaxTime();
                }
                if (this.minTime == -1L || record.getMinTime() < this.minTime) {
                    this.minTime = record.getMinTime();
                }
                this.totalCount = updatedTotalCount;
            }
        }
    }
}

