/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mediation.statistics;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.aspects.ComponentType;
import org.apache.synapse.aspects.statistics.ErrorLog;
import org.apache.synapse.aspects.statistics.view.InOutStatisticsView;
import org.wso2.carbon.mediation.statistics.MediationStatisticsObserver;
import org.wso2.carbon.mediation.statistics.MediationStatisticsSnapshot;
import org.wso2.carbon.mediation.statistics.MessageTraceLog;
import org.wso2.carbon.mediation.statistics.StatisticsRecord;

public class MediationStatisticsStore {
    private static final Log log = LogFactory.getLog(MediationStatisticsStore.class);
    private Map<ComponentType, Map<String, StatisticsRecord>> inDataStore = new HashMap<ComponentType, Map<String, StatisticsRecord>>();
    private Map<ComponentType, Map<String, StatisticsRecord>> outDataStore = new HashMap<ComponentType, Map<String, StatisticsRecord>>();
    private Map<ComponentType, StatisticsRecord> categoryInDataStore = new HashMap<ComponentType, StatisticsRecord>();
    private Map<ComponentType, StatisticsRecord> categoryOutDataStore = new HashMap<ComponentType, StatisticsRecord>();
    private Set<MediationStatisticsObserver> observers = new HashSet<MediationStatisticsObserver>();

    public void registerObserver(MediationStatisticsObserver o) {
        this.observers.add(o);
    }

    public void unregisterObserver(MediationStatisticsObserver o) {
        if (this.observers.contains(o)) {
            this.observers.remove(o);
            o.destroy();
        }
    }

    void unregisterObservers() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Unregistering mediation statistics observers");
        }
        for (MediationStatisticsObserver o : this.observers) {
            o.destroy();
        }
        this.observers.clear();
    }

    void updateStatistics(InOutStatisticsView view) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Received statistics update event");
        }
        if (view.getInStatistics() != null) {
            StatisticsRecord inRecord = new StatisticsRecord(view.getResourceId(), view.getComponentType(), true, view.getInStatistics());
            this.updateRecord(inRecord, view.getInStatistics().getErrorLogs());
        }
        if (view.getOutStatistics() != null) {
            StatisticsRecord outRecord = new StatisticsRecord(view.getResourceId(), view.getComponentType(), false, view.getOutStatistics());
            this.updateRecord(outRecord, view.getOutStatistics().getErrorLogs());
        }
    }

    private void updateRecord(StatisticsRecord record, List<ErrorLog> errorLogs) {
        StatisticsRecord oldRecord;
        Map<ComponentType, StatisticsRecord> categoryDataStore;
        Map<ComponentType, Map<String, StatisticsRecord>> dataStore;
        if (record.getTotalCount() == 0) {
            return;
        }
        StatisticsRecord entitySnapshot = null;
        StatisticsRecord categorySnapshot = null;
        if (record.isInStatistic()) {
            dataStore = this.inDataStore;
            categoryDataStore = this.categoryInDataStore;
        } else {
            dataStore = this.outDataStore;
            categoryDataStore = this.categoryOutDataStore;
        }
        Map<String, StatisticsRecord> allRecords = dataStore.get(record.getType());
        if (allRecords == null) {
            allRecords = new HashMap<String, StatisticsRecord>();
            dataStore.put(record.getType(), allRecords);
        }
        if ((oldRecord = allRecords.get(record.getResourceId())) == null) {
            allRecords.put(record.getResourceId(), record);
        } else {
            entitySnapshot = new StatisticsRecord(oldRecord);
            oldRecord.updateRecord(record);
        }
        StatisticsRecord categoryRecord = categoryDataStore.get(record.getType());
        if (categoryRecord == null) {
            categoryRecord = new StatisticsRecord("CATEGORY-DATA", record.getType(), record.isInStatistic(), null);
            categoryRecord.setTotalCount(record.getTotalCount());
            categoryRecord.setFaultCount(record.getFaultCount());
            categoryRecord.setMaxTime(record.getMaxTime());
            categoryRecord.setMinTime(record.getMinTime());
            categoryRecord.setAvgTime(record.getAvgTime());
            categoryDataStore.put(categoryRecord.getType(), categoryRecord);
        } else {
            categorySnapshot = new StatisticsRecord(categoryRecord);
            categoryRecord.updateRecord(record);
        }
        MediationStatisticsSnapshot snapshot = new MediationStatisticsSnapshot();
        snapshot.setUpdate(record);
        snapshot.setEntitySnapshot(entitySnapshot);
        snapshot.setCategorySnapshot(categorySnapshot);
        snapshot.setErrorLogs(errorLogs);
        this.notifyObservers(snapshot);
    }

    private void notifyObservers(MediationStatisticsSnapshot snapshot) {
        for (MediationStatisticsObserver o : this.observers) {
            try {
                o.updateStatistics(snapshot);
            }
            catch (Throwable t) {
                log.error((Object)"Error occured while notifying the statistics observer", t);
            }
        }
    }

    public void notifyTraceLogs(MessageTraceLog[] logs) {
        for (MediationStatisticsObserver o : this.observers) {
            try {
                o.notifyTraceLogs(logs);
            }
            catch (Throwable t) {
                log.error((Object)"Error occured while notifying the statistics observer", t);
            }
        }
    }

    public String[] getResourceNames(ComponentType type) {
        Map<String, StatisticsRecord> outDataMap;
        HashSet<String> resourceNames = new HashSet<String>();
        Map<String, StatisticsRecord> inDataMap = this.inDataStore.get(type);
        if (inDataMap != null) {
            resourceNames.addAll(inDataMap.keySet());
        }
        if ((outDataMap = this.outDataStore.get(type)) != null) {
            resourceNames.addAll(outDataMap.keySet());
        }
        return resourceNames.toArray(new String[resourceNames.size()]);
    }

    public StatisticsRecord getRecordByResource(String resourceId, ComponentType type, boolean inStatistic) {
        Map<String, StatisticsRecord> dataMap;
        Map<String, StatisticsRecord> map = dataMap = inStatistic ? this.inDataStore.get(type) : this.outDataStore.get(type);
        if (dataMap != null) {
            return dataMap.get(resourceId);
        }
        return null;
    }

    public StatisticsRecord getRecordByCategory(ComponentType type, boolean inStatistic) {
        return inStatistic ? this.categoryInDataStore.get(type) : this.categoryOutDataStore.get(type);
    }

    public Map<String, Integer> getTotalCounts(ComponentType type) {
        HashMap<String, Integer> totalCountsMap = new HashMap<String, Integer>();
        Map<String, StatisticsRecord> inDataMap = this.inDataStore.get(type);
        this.populateCountsMap(totalCountsMap, inDataMap);
        if (type == ComponentType.SEQUENCE) {
            Map<String, StatisticsRecord> outDataMap = this.outDataStore.get(type);
            this.populateCountsMap(totalCountsMap, outDataMap);
        }
        return totalCountsMap;
    }

    private void populateCountsMap(Map<String, Integer> totalCountsMap, Map<String, StatisticsRecord> dataMap) {
        if (dataMap != null) {
            for (Map.Entry<String, StatisticsRecord> entry : dataMap.entrySet()) {
                String key = entry.getKey();
                if (key.contains("__")) {
                    key = key.substring(0, key.lastIndexOf("__"));
                }
                if (totalCountsMap.containsKey(key)) {
                    int currentVal = totalCountsMap.get(key);
                    totalCountsMap.put(key, currentVal + entry.getValue().getTotalCount());
                    continue;
                }
                totalCountsMap.put(key, entry.getValue().getTotalCount());
            }
        }
    }
}

