/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mediation.statistics;

import java.util.Dictionary;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.wso2.carbon.base.ServerConfiguration;
import org.wso2.carbon.core.multitenancy.SuperTenantCarbonContext;
import org.wso2.carbon.mediation.initializer.services.SynapseEnvironmentService;
import org.wso2.carbon.mediation.initializer.services.SynapseRegistrationsService;
import org.wso2.carbon.mediation.statistics.MediationStatisticsObserver;
import org.wso2.carbon.mediation.statistics.MediationStatisticsStore;
import org.wso2.carbon.mediation.statistics.ServiceReferenceHolder;
import org.wso2.carbon.mediation.statistics.StatisticsReporterThread;
import org.wso2.carbon.mediation.statistics.TenantInformation;
import org.wso2.carbon.mediation.statistics.persistence.PersistingStatisticsObserver;
import org.wso2.carbon.mediation.statistics.services.MediationStatisticsService;
import org.wso2.carbon.mediation.statistics.services.MediationStatisticsServiceImpl;
import org.wso2.carbon.registry.core.service.RegistryService;

public class MediationStatisticsServiceComponent {
    private static final Log log = LogFactory.getLog(MediationStatisticsServiceComponent.class);
    private Map<Integer, MediationStatisticsStore> stores = new HashMap<Integer, MediationStatisticsStore>();
    private Map<Integer, StatisticsReporterThread> reporterThreads = new HashMap<Integer, StatisticsReporterThread>();
    private Map<Integer, SynapseEnvironmentService> synapseEnvServices = new HashMap<Integer, SynapseEnvironmentService>();
    private boolean initialized = false;
    private Map<Integer, MediationStatisticsService> services = new HashMap<Integer, MediationStatisticsService>();
    private ComponentContext compCtx;

    protected void activate(ComponentContext compCtx) throws Exception {
        this.compCtx = compCtx;
        try {
            SynapseEnvironmentService synapseEnvService = this.synapseEnvServices.get(-1234);
            if (synapseEnvService != null) {
                this.createStatisticsStore(synapseEnvService);
                MediationStatisticsStore store = this.stores.get(-1234);
                MediationStatisticsServiceImpl service = new MediationStatisticsServiceImpl(store, -1234, synapseEnvService.getConfigurationContext());
                this.services.put(-1234, service);
                compCtx.getBundleContext().registerService(MediationStatisticsService.class.getName(), (Object)service, (Dictionary)new Properties());
                this.initialized = true;
            } else {
                log.error((Object)"Couldn't initialize Mediation Statistics");
            }
        }
        catch (Throwable e) {
            log.fatal((Object)"Error while initializing Mediation Statistics : ", e);
        }
    }

    private void createStatisticsStore(SynapseEnvironmentService synEnvService) {
        String observers;
        String persistence;
        String tracing;
        ConfigurationContext cfgCtx = synEnvService.getConfigurationContext();
        int tenantId = SuperTenantCarbonContext.getCurrentContext((ConfigurationContext)cfgCtx).getTenantId();
        MediationStatisticsStore mediationStatStore = new MediationStatisticsStore();
        cfgCtx.setProperty("MediationStatisticsStore", (Object)mediationStatStore);
        StatisticsReporterThread reporterThread = new StatisticsReporterThread(synEnvService, mediationStatStore);
        reporterThread.setName("mediation-stat-collector-" + tenantId);
        ServerConfiguration serverConf = ServerConfiguration.getInstance();
        String interval = serverConf.getFirstProperty("MediationStat.ReportingInterval");
        if (interval != null) {
            reporterThread.setDelay(Long.parseLong(interval));
        }
        if ("enabled".equals(tracing = serverConf.getFirstProperty("MediationStat.MessageTracing"))) {
            reporterThread.setTracingEnabled(true);
        }
        if ("enabled".equals(persistence = serverConf.getFirstProperty("MediationStat.Persistence"))) {
            String root = serverConf.getFirstProperty("MediationStat.RegistryLocation");
            if (root != null) {
                log.info((Object)("Enabling mediation statistics persistence. Statistics will be stored at: " + root));
                mediationStatStore.registerObserver(new PersistingStatisticsObserver(root));
            } else {
                log.warn((Object)"MediationStat.RegistryLocation parameter has not been specified in the server configuration to activate statistics persistence");
            }
        }
        if ((observers = serverConf.getFirstProperty("MediationStat.Observers")) != null && !"".equals(observers)) {
            String[] classNames;
            for (String className : classNames = observers.split(",")) {
                try {
                    Class<?> clazz = this.getClass().getClassLoader().loadClass(className.trim());
                    MediationStatisticsObserver o = (MediationStatisticsObserver)clazz.newInstance();
                    mediationStatStore.registerObserver(o);
                    if (!(o instanceof TenantInformation)) continue;
                    TenantInformation tenantInformation = (TenantInformation)((Object)o);
                    tenantInformation.setTenantId(synEnvService.getTenantId());
                }
                catch (Exception e) {
                    log.error((Object)("Error while initializing the mediation statistics observer : " + className), (Throwable)e);
                }
            }
        }
        reporterThread.start();
        if (log.isDebugEnabled()) {
            log.debug((Object)"Registering the mediation statistics service");
        }
        this.reporterThreads.put(tenantId, reporterThread);
        this.stores.put(tenantId, mediationStatStore);
    }

    protected void deactivate(ComponentContext compCtx) throws Exception {
        Set<Map.Entry<Integer, StatisticsReporterThread>> threadEntries = this.reporterThreads.entrySet();
        for (Map.Entry<Integer, StatisticsReporterThread> threadEntry : threadEntries) {
            StatisticsReporterThread reporterThread = threadEntry.getValue();
            if (reporterThread == null || !reporterThread.isAlive()) continue;
            reporterThread.shutdown();
            reporterThread.interrupt();
            while (reporterThread.isAlive()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Waiting for the statistics reporter thread to terminate");
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException ignore) {}
            }
        }
        Set<Map.Entry<Integer, MediationStatisticsStore>> storeEntries = this.stores.entrySet();
        for (Map.Entry<Integer, MediationStatisticsStore> storeEntry : storeEntries) {
            storeEntry.getValue().unregisterObservers();
        }
    }

    protected void setSynapseEnvironmentService(SynapseEnvironmentService synEnvService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"SynapseEnvironmentService bound to the mediation statistics initialization");
        }
        this.synapseEnvServices.put(synEnvService.getTenantId(), synEnvService);
    }

    protected void unsetSynapseEnvironmentService(SynapseEnvironmentService synEnvService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"SynapseEnvironmentService unbound from the mediation statistics collector");
        }
        this.synapseEnvServices.remove(synEnvService.getTenantId());
    }

    protected void setRegistryService(RegistryService registryService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"RegistryService bound to the mediation statistics initialization");
        }
        ServiceReferenceHolder.getInstance().setRegistrySvc(registryService);
    }

    protected void unsetRegistryService(RegistryService registryService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"RegistryService unbound from the mediation statistics collector");
        }
        ServiceReferenceHolder.getInstance().setRegistrySvc(null);
    }

    protected void setSynapseRegistrationsService(SynapseRegistrationsService registrationsService) {
        ServiceRegistration synEnvSvcRegistration = registrationsService.getSynapseEnvironmentServiceRegistration();
        try {
            if (this.initialized && this.compCtx != null) {
                SynapseEnvironmentService synEnvSvc = (SynapseEnvironmentService)this.compCtx.getBundleContext().getService(synEnvSvcRegistration.getReference());
                this.createStatisticsStore(synEnvSvc);
                int tenantId = registrationsService.getTenantId();
                MediationStatisticsStore store = this.stores.get(tenantId);
                if (store != null) {
                    MediationStatisticsServiceImpl service = new MediationStatisticsServiceImpl(store, registrationsService.getTenantId(), registrationsService.getConfigurationContext());
                    this.services.put(registrationsService.getTenantId(), service);
                    this.compCtx.getBundleContext().registerService(MediationStatisticsService.class.getName(), (Object)service, (Dictionary)new Properties());
                } else {
                    log.warn((Object)("Couldn't find the mediation statistics store for tenant id: " + tenantId));
                }
            }
        }
        catch (Throwable t) {
            log.fatal((Object)"Error occurred at the osgi service method", t);
        }
    }

    protected void unsetSynapseRegistrationsService(SynapseRegistrationsService registrationsService) {
        try {
            MediationStatisticsStore store;
            int tenantId = registrationsService.getTenantId();
            StatisticsReporterThread reporterThread = this.reporterThreads.get(tenantId);
            if (reporterThread != null && reporterThread.isAlive()) {
                reporterThread.shutdown();
                reporterThread.interrupt();
                while (reporterThread.isAlive()) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Waiting for the statistics reporter thread to terminate");
                    }
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException ignore) {}
                }
            }
            if ((store = this.stores.get(tenantId)) != null) {
                store.unregisterObservers();
            }
        }
        catch (Throwable t) {
            log.error((Object)"Fatal error occured at the osgi service method", t);
        }
    }
}

